/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.base;

import java.util.logging.Level;

/**
	Interface that all AMX MBeans implement for logging.
 */
public interface AMXMBeanLogging
{
	/**
		Get the log level.  If the String form is desired, use Level.toString().
		@return the log Level for this MBean
	*/
	public Level	getMBeanLogLevel();
	
	/**
	    Set the log level for this MBean.
	 */
	public void		setMBeanLogLevel( Level level );
	
	/**
	    @return the name of the java.util.logging.Logger used by
	    this MBean.
	 */
	public String	getMBeanLoggerName();
}











