/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.base;

import java.util.Map;

import javax.management.InstanceNotFoundException;

import com.sun.appserv.management.base.Container;

/**
	Manages the creation and removal of NotificationService MBeans.
 */
public interface NotificationServiceMgr extends AMX, Utility, Container
{
/** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
	public static final String	J2EE_TYPE			= XTypes.NOTIFICATION_SERVICE_MGR;
	
	/**
		@return Map of all {@link NotificationService} keyed by name
	 */	
	public Map<String,NotificationService> getNotificationServiceMap( );
	
	/**
	    Get the specified {@link NotificationService}.
	    @param name
	 */
	public NotificationService		getNotificationService( final String name );
	
	/**
		Create a new NotificationService (j2eeType={@link XTypes#NOTIFICATION_SERVICE}).
		{@link NotificationService#getName} can later be used
		to retrieve the NotificationService via {@link #getNotificationService}.
		
		@param userData
		@param bufferSize
		@return NotificationService
	 */
	public NotificationService		createNotificationService( Object userData, int bufferSize );
	
	/**
	    Remove the specified {@link NotificationService}.
	    @param name
	 */
	public void removeNotificationService( final String name )
					 throws InstanceNotFoundException;
}
