/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.base;

import java.util.Map;
import java.io.Serializable;

import com.sun.appserv.management.util.misc.ThrowableMapper;

/**
	Base class for OperationStatus.
 */

public class OperationStatusBase
	extends MapCapableBase
	implements OperationStatus
{
	
	/**
		Create a new instance which represents the appropriate class.
		
		@param m			a Map representing the appropriate class
		@param className	the class which the Map represents
	 */
		public <T extends Serializable>
	OperationStatusBase(
		final Map<String,T>		m,
		final String	className )
	{
		super( m, className );
	}
	
	
		protected boolean
	validate()
	{
		// nothing to do for now
		return( true );
	}
	
	/**
	    @return the status code from the operation
	 */
		public int
	getStatusCode()
	{
		int	statusCode	= STATUS_CODE_FAILURE;
		
		final Integer	code	= getInteger( STATUS_CODE_KEY );
		if ( code != null )
		{
			statusCode	= code.intValue();
		}
		else
		{
			statusCode	= getThrowable() != null ?
					STATUS_CODE_FAILURE : STATUS_CODE_SUCCESS;
		}
		
		return( statusCode );
	}
	
	/**
	    set the status code for the operation
	 */
		public void
	setStatusCode( final int statusCode )
	{
		putField( STATUS_CODE_KEY, new Integer( statusCode ) );
	}
	
	
	/**
	    @return a Throwable for the operation, or null if none
	 */
		public Throwable
	getThrowable()
	{
		return( (Throwable)getObject( THROWABLE_KEY ) );
	}
	
	
	/**
	    Set the Throwable for the operation, which may be null.
	 */
		public void
	setThrowable( final Throwable t)
	{
		final Throwable	conforming	= new ThrowableMapper( t ).map();
		
		putField( THROWABLE_KEY, conforming );
	}
	
	
}








