/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/base/Attic/Sample.java,v 1.3 2005/12/25 03:49:00 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:49:00 $
 */
package com.sun.appserv.management.base;

import javax.management.Attribute;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.XTypes;

/**
	Interface for a sample MBean , used as target for sample and test code.
	Various Attributes of varying types are made available for testing.
 */
public interface Sample extends Utility, AMX, Singleton
{
/** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
	public static final String	J2EE_TYPE			= XTypes.SAMPLE;
	
	/**
		The type of Notification emitted by emitNotification().
	 */
	public static final String	SAMPLE_NOTIFICATION_TYPE	= "Sample";
	
	/**
		The key to access user data within the Map obtained from Notification.getUserData().
	 */
	public static final String	USER_DATA_KEY				= "UserData";
	
	/**
		Emit 'numNotifs' notifications of type
		SAMPLE_NOTIFICATION_TYPE at the specified interval.
		
		@param data arbitrary data which will be placed into the Notification's UserData field.
		@param numNotifs number of Notifications to issue >= 1
		@param intervalMillis interval at which Notifications should be issued >= 0
	 */
	public void	emitNotifications( final Object data, final int numNotifs, final long intervalMillis );
	
	/** 
		Add a new Attribute. After this, the MBeanInfo will contain an MBeanAttributeInfo
		for this Attribute.
		
		@param name
		@param value
	 */
	public void 	addAttribute( final String name, final Object value );
	
	/** 
		Remove an Attribute. After this, the MBeanInfo will no longer
		contain an MBeanAttributeInfo for this Attribute.
	 */
	public void 	removeAttribute( final String name );
	
	/**
		For testing bandwidth...
	 */
	public void		uploadBytes( final byte[] bytes );
	public byte[]	downloadBytes( final int numBytes );
}
