/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.client.handler;

import java.lang.reflect.Method;

import java.util.List;

import java.io.Serializable;
import java.io.IOException;

import javax.management.ObjectName;

import com.sun.appserv.management.client.ConnectionSource;

import com.sun.appserv.management.util.misc.TypeCast;

import com.sun.appserv.management.ext.logging.LogQueryResult;
import com.sun.appserv.management.ext.logging.LogQueryResultImpl;


/**
    Specialized handler for {@link com.sun.appserv.management.ext.logging.Logging}.
 */
final class LoggingConverterHandler extends ConverterHandler
{
		public
	LoggingConverterHandler(
		final ConnectionSource		connectionSource,
		final ObjectName			proxiedMBeanObjectName )
		throws IOException
	{
		super( connectionSource, proxiedMBeanObjectName );
	}
	
    /**
        @override
     */
        protected Object
    convertResult(
        final Method method,
        final Object resultIn )
    {
        Object  resultOut   = resultIn;
        
        if ( method.getName().equals( "queryServerLog" ) )
        {
            final List<Serializable[]>  ls  = TypeCast.asList( resultIn );
            
            final LogQueryResult converted = new LogQueryResultImpl( ls );
            resultOut   = converted;
        }
        
        return resultOut;
    }
}





