/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.config;

import com.sun.appserv.management.base.XTypes;

/**
	 Represents the &lt;access-log&gt; element.
	 <p>
*/

public interface AccessLogConfig extends ConfigElement 
{
/** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
	public static final String	J2EE_TYPE	= XTypes.ACCESS_LOG_CONFIG;

	public String	getFormat();
	public void	setFormat( final String value );

	public boolean	getRotationEnabled();
	public void	setRotationEnabled( final boolean value );

	public String	getRotationIntervalInMinutes();
	public void	setRotationIntervalInMinutes( final String value );

	
	/**
		Possible value for RotationPolicy.
	 */
	public static final String	ROTATION_POLICY_BY_TIME		= "time";
	/**
		Possible value for RotationPolicy.
	 */
	public static final String	ROTATION_POLICY_BY_SIZE		= "size";
	/**
		Possible value for RotationPolicy.
	 */
	public static final String	ROTATION_POLICY_ON_DEMAND	= "on-demand";
	
	/**
		Valid values are:
		<ul>
		<li>{@link #ROTATION_POLICY_BY_TIME}</li>
		<li>{@link #ROTATION_POLICY_BY_SIZE}</li>
		<li>{@link #ROTATION_POLICY_ON_DEMAND}</li>
		</ul>
	*/
	public void	setRotationPolicy( final String value );
	public String	getRotationPolicy();

	public String	getRotationSuffix();
	public void	setRotationSuffix( final String value );



}
