/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/config/Attic/ConfigConfig.java,v 1.12 2006/03/09 20:30:23 llc Exp $
 * $Revision: 1.12 $
 * $Date: 2006/03/09 20:30:23 $
 */


package com.sun.appserv.management.config;

import java.util.Map;

import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.base.Container;

/**
	 Configuration for the &lt;config&gt; element.
 */
public interface ConfigConfig
	extends PropertiesAccess, SystemPropertiesAccess,
	NamedConfigElement, Container
{
	/**
		Configuration of the config element itself.
	 */
/** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
	public static final String	J2EE_TYPE	= XTypes.CONFIG_CONFIG;
	
	
	/**
		Calls Container.getContaineeMap( XTypes.THREAD_POOL_CONFIG ).
		@return Map of ThreadPoolConfig proxies, keyed by name.
		@see com.sun.appserv.management.base.Container#getContaineeMap
	 */
	public Map<String,ThreadPoolConfig>	getThreadPoolConfigMap();
	

	/**
		Return the IIOPServiceConfig.
	 */
	public IIOPServiceConfig	getIIOPServiceConfig();
	
	/**
		Return the HTTPServiceConfig.
	 */
	public HTTPServiceConfig	getHTTPServiceConfig();
	
	/**
		Return the SecurityServiceConfig.
	 */
	public SecurityServiceConfig	getSecurityServiceConfig();
	
	/**
		Return the MonitoringServiceConfig.
	 */
	public MonitoringServiceConfig	getMonitoringServiceConfig();
	
	/**
		Return the AdminServiceConfig.
	 */
	public AdminServiceConfig	getAdminServiceConfig();
		
	/**
		Create a new &lt;thread-pool>
		
		@param name			name of the &lt;thread-pool> (thread-pool-id)
		@param optional		Map of optional attributes and properties whose keys
		are defined here. (eg:- MIN_THREAD_POOL_SIZE_KEY)
		@return A proxy to the ThreadPoolConfig MBean.
		@see ThreadPoolConfigKeys
	 */
	public ThreadPoolConfig	createThreadPoolConfig( String name, Map<String,String> optional );

	/**
		Removes a thread-pool element.

		@param name			name of the &lt;thread-pool> (thread-pool-id)
	 */
	public void			removeThreadPoolConfig( String name );
	
	
	/**
		Return the WebContainerConfig.
	 */
	public WebContainerConfig	getWebContainerConfig() ;
	
	/**
		Return the EJBContainerConfig.
	 */
	public EJBContainerConfig	getEJBContainerConfig() ;
	
	/**
		Return the MDBContainerConfig.
	 */
	public MDBContainerConfig	getMDBContainerConfig();
	
	/**
		Return the JavaConfig.
	 */
	public JavaConfig	getJavaConfig();
	
	/**
		Return the JMSServiceConfig.
	 */
	public JMSServiceConfig	getJMSServiceConfig();
	
	/**
		Return the LogServiceConfig.
	 */
	public LogServiceConfig	getLogServiceConfig();
	
	/**
		Return the TransactionServiceConfig.
	 */
	public TransactionServiceConfig	getTransactionServiceConfig();
	
	/**
		Return the AvailabilityServiceConfig.
	 */
	public AvailabilityServiceConfig	getAvailabilityServiceConfig();

	/**
		Return the ConnectorServiceConfig.
	 */
	public ConnectorServiceConfig	getConnectorServiceConfig();
	
	/**
	    Create the ConnectorServiceConfig if it doesn't already exist.
	 */
	public ConnectorServiceConfig	createConnectorServiceConfig();
	public void     removeConnectorServiceConfig();


	/**
	    Return the DiagnosticServiceConfig.  May be null.
	    @since AppServer 9.0
        */
	public DiagnosticServiceConfig getDiagnosticServiceConfig();
	
	/**
	    Create the DiagnosticServiceConfig.
	    @since AppServer 9.0
        */
	public DiagnosticServiceConfig createDiagnosticServiceConfig();
	
	/**
	    Remove the DiagnosticServiceConfig.
	    @since AppServer 9.0
        */
	public void removeDiagnosticServiceConfig();
	

	/**
	Return the Group Management Service configuration.
	@since AppServer 9.0
	*/
	public GroupManagementServiceConfig getGroupManagementServiceConfig();
	
	/**                  
        When set to "true" then any changes to the system (e.g.       
        applications deployed, resources created) will be             
        automatically applied to the affected servers without a       
        restart being required. When set to "false" such changes will 
        only be picked up by the affected servers when each server    
        restarts.
        @since AppServer 9.0                                                
     */
	public boolean   getDynamicReconfigurationEnabled();
	
	/**
	    @see #getDynamicReconfigurationEnabled
        @since AppServer 9.0
	 */
	public void      setDynamicReconfigurationEnabled( boolean enabled );
	
	/**
	    @return ManagementRulesConfig (may be null );
	 */
	public ManagementRulesConfig    getManagementRulesConfig();
}

















