/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/config/Attic/ConnectorConnectionPoolConfigKeys.java,v 1.3 2005/12/25 03:49:22 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:49:22 $
 */
package com.sun.appserv.management.config;

/**
	Keys for use with {@link DomainConfig#createConnectorConnectionPoolConfig}.
 */
public final class ConnectorConnectionPoolConfigKeys extends CommonConfigKeys
{
	private	ConnectorConnectionPoolConfigKeys()	{}
	/**
		Key for use with {@link DomainConfig#createConnectorConnectionPoolConfig}, value must be java.lang.String.
	*/
	public static final String	STEADY_POOL_SIZE_KEY		= "SteadyPoolSize";

	/**
		Key for use with {@link DomainConfig#createConnectorConnectionPoolConfig}, value must be java.lang.String.
	*/
	public static final String	MAX_POOL_SIZE_KEY		    = "MaxPoolSize";

	/**
		Key for use with {@link DomainConfig#createConnectorConnectionPoolConfig}, value must be java.lang.String.
	*/
	public static final String	MAX_WAIT_TIME_IN_MILLIS_KEY	= "MaxWaitTimeMillis";

	/**
		Key for use with {@link DomainConfig#createConnectorConnectionPoolConfig}, value must be java.lang.String.
	*/
	public static final String	POOL_RESIZE_QUANTITY_KEY	= "PoolResizeQuantity";

	/**
		Key for use with {@link DomainConfig#createConnectorConnectionPoolConfig}, value must be java.lang.String.
	*/
	public static final String	IDLE_TIMEOUT_IN_SECONDS_KEY	= "IdleTimeoutInSeconds";

	/**
		Key for use with {@link DomainConfig#createConnectorConnectionPoolConfig}, value must be java.lang.Boolean.
	*/
	public static final String	FAIL_ALL_CONNECTIONS_KEY		= "FailAllConnections";
	
	/**
		Key for use with {@link DomainConfig#createConnectorConnectionPoolConfig}, value must be java.lang.String.
		
		                                   
        Indicates the level of transaction support that this pool     
        will have. Possible values are as defined in {@link TransactionSupportValues}.
        This attribute will   
        override that transaction support attribute in the Resource   
        Adapter in a downward compatible way, i.e it can support a    
        lower/equal transaction level than specified in the RA, but   
        not a higher level.
        @see ConnectorConnectionPoolConfig#setTransactionSupport      
	*/
	public static final String	TRANSACTION_SUPPORT_KEY		= "TransactionSupport";
}









