/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */



/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/config/Attic/DASConfig.java,v 1.5 2005/12/25 03:49:24 tcfujii Exp $
 * $Revision: 1.5 $
 * $Date: 2005/12/25 03:49:24 $
 */


package com.sun.appserv.management.config;

import com.sun.appserv.management.base.XTypes;


/**
	
	 Configuration for the &lt;das-config&gt; element.
	
	The name is confusing, this item actually lives inside an <admin-service>,
	which is in turn inside a <config>
 */
public interface DASConfig extends ConfigElement, PropertiesAccess
{
/** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
	public static final String	J2EE_TYPE	= XTypes.DAS_CONFIG;
	
	public String	getAdminSessionTimeoutInMinutes();
	public void	setAdminSessionTimeoutInMinutes( String value );

	public String	getAutodeployDir();
	public void	setAutodeployDir( String value );

	public boolean	getAutodeployEnabled();
	public void	setAutodeployEnabled( boolean value );

	public boolean	getAutodeployJSPPrecompilationEnabled();
	public void	setAutodeployJSPPrecompilationEnabled( boolean value );

	public String	getAutodeployPollingIntervalInSeconds();
	public void	setAutodeployPollingIntervalInSeconds( String value );

	public boolean	getAutodeployVerifierEnabled();
	public void	setAutodeployVerifierEnabled( boolean value );

	/**
		See {@link ValidationLevelValues}.  Read-only.
	 */
	public String	getDeployXMLValidation();

	public boolean	getDynamicReloadEnabled();
	public void	setDynamicReloadEnabled( boolean value );

	public String	getDynamicReloadPollIntervalInSeconds();
	public void	setDynamicReloadPollIntervalInSeconds( String value );




}
