/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/config/Attic/ObjectTypeValues.java,v 1.3 2005/12/25 03:49:52 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:49:52 $
 */


package com.sun.appserv.management.config;


/**
	Values which are legal to pass for the object-type.
	
	object-type  defines the type of the resource. It can be:
    system-all       These are system resources for all instances and DAS
    system-admin     These are system resources only in DAS
    system-instance  These are system resources only in instances (and not DAS)
    user             User resources (This is the default for all elements)
    
    @see ObjectType
 */
public final class ObjectTypeValues
{
	private	ObjectTypeValues()	{}
	
	public static final String		SYSTEM_ALL		= "system-all";
	public static final String		SYSTEM_ADMIN	= "system-admin";
	public static final String		SYSTEM_INSTANCE	= "system-instance";
	public static final String		USER			= "user";
	
}
