/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.appserv.management.config;

import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.base.Container;



/**
    Represents the &lt;security-map> element.
    <p>
    Perform mapping from principal received during Servlet/EJB        
    authentication, to credentials accepted by the EIS. This mapping  
    is optional.It is possible to map multiple (server) principal to  
    the same backend principal.    
    
	@since Appserver 9.0
*/
public interface SecurityMapConfig
    extends ConfigElement, Container
{
/** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
	public static final String	J2EE_TYPE	= XTypes.SECURITY_MAP_CONFIG;
	
	public String[]  getPrincipalNames();
	public void      createPrincipal( String name );
	public void      removePrincipal( String name );
	
	public String[]  getUserGroupNames();
	public void      createUserGroup( String name );
	public void      removeUserGroup( String name );
	
	public BackendPrincipalConfig       getBackendPrincipalConfig(); 
}
