/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * DeploymentSource.java
 *
 * Created on April 8, 2004, 9:13 AM
 */

package com.sun.appserv.management.deploy;

import java.io.File;
import java.io.IOException;
import java.util.jar.JarInputStream;

import com.sun.appserv.management.base.MapCapable;

/**
	Abstraction for archives delivery for a deployment operation

	This interface may be instantiated by using routines in
	{@link com.sun.appserv.management.deploy.DeploymentSupport}
 */
public interface DeploymentSource extends MapCapable
{
	/**
		Value of the MAP_CAPABLE_TYPE_KEY when turned into a Map.
	 */
	public final static String	DEPLOYMENT_SOURCE_CLASS_NAME	= 
			"com.sun.appserv.management.deploy.DeploymentSource";
			
    /** 
     * (Optional)
     * @return the archive as a file handle if possible 
     * otherwise return null.
     */
    public File getArchive();
       
    /** 
     * @return a JarInputStream on the archive. 
     */
    public JarInputStream getArchiveAsStream()
    	throws IOException;
    
    /** 
     * @return true if this archive is complete or false
     * if it is a partial delivery (redeploy).
     */
    public boolean isCompleteArchive();
    
    /**
     * In case of a partial delivery.
     * @return entries added iterator
     */
    public String[] getEntriesAdded();
    
    /**
     * In case of a partial archive delivery.
     * @return entries removed iterator
     */
    public String[] getEntriesRemoved();
    
    /**
     * In case of a partial delivery.
     * @return entries deleted iterator
     */
    public String[] getEntriesDeleted();
}
