/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.deploy;

import java.util.Map;
import java.io.Serializable;

import com.sun.appserv.management.deploy.DeploymentSource;
import com.sun.appserv.management.deploy.DeploymentProgress;
import com.sun.appserv.management.deploy.DeploymentStatus;


/**
	Routines to convert to/from Map and Deployment types.

	{link com.sun.appserv.management.deploy.DeploymentMgr}
 */

public final class DeploymentSupport
{
	/**
		Create a DeploymentSource represented by a Map.
		
		@param m a Map representing a DeploymentSource.
		@return an implementation of DeploymentSource
	 */
		public static <T extends Serializable> DeploymentSource
	mapToDeploymentSource( final Map<String,T> m )
	{
		return( new DeploymentSourceImpl( m ) );
	}
	
	
	/**
		Create a DeploymentProgress represented by a Map.
		
		@param m a Map representing a DeploymentProgress.
		@return an implementation of DeploymentProgress
	 */
		public static <T extends Serializable> DeploymentProgress
	mapToDeploymentProgress( final Map<String,T> m )
	{
		return( new DeploymentProgressImpl( m ) );
	}
	
	
	/**
		Create a DeploymentProgress represented by a Map.
		
		@param m a Map representing a DeploymentStatus.
		@return a DeploymentStatus
	 */
		public static <T extends Serializable> DeploymentStatus
	mapToDeploymentStatus( final Map<String,T> m )
	{
		return( new DeploymentStatusImpl( m ) );
	}
}



