/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/j2ee/Attic/J2EEDeployedObject.java,v 1.3 2005/12/25 03:50:41 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:50:41 $
 */
 
package com.sun.appserv.management.j2ee;

/**
 */
public interface J2EEDeployedObject extends J2EEManagedObject, StateManageable
{
	/**
		The deploymentDescriptor string must contain the original XML
		deployment descriptor that was created for this module during
		the deployment process.
		<p>
		Note that the Attribute name is case-sensitive
		"deploymentDescriptor" as defined by JSR 77.
	*/
	public String	getdeploymentDescriptor();
	
	/**
		The J2EEServer this module is deployed on.
		Get the ObjectNames, as String.
		<p>
		Note that the Attribute name is case-sensitive
		"server" as defined by JSR 77.
		
		@return the ObjectName of the server, as a String
	 */
	public String	getserver();


	public J2EEServer	getServer();
}
