/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.j2ee;

import java.util.Map;

import java.io.Serializable;

import com.sun.appserv.management.j2ee.J2EEManagedObject;
import com.sun.appserv.management.j2ee.J2EETypes;
import com.sun.appserv.management.monitor.WebServiceEndpointMonitor;
import com.sun.appserv.management.ext.wsmgmt.MessageTrace;
import com.sun.appserv.management.monitor.statistics.WebServiceEndpointAggregateStats;

/**
 * The extension to the JSR 77 hierarchy for a WebService Endpoint.  
 * 
 * @since AppServer 9.0
 */
public interface WebServiceEndpoint extends J2EEManagedObject
{
    public final static String J2EE_TYPE = J2EETypes.WEB_SERVICE_ENDPOINT;

    /**
     * Implementation {@link Servlet} or {@link EJB} JSR77 mbean is returned.
     *
     * @return Implementation {@link Servlet} or {@link EJB} JSR77 mbean 
     */
    //public J2EEManagedObject getImplementationPeer();

    /**
     * This returns the underlying implementation Servlet or EJB' type
     * 
     * @return either SERVLET or EJB
     */
    public String getImplementationType();


    /**
     * Returns last N message content and info collected for this web service.
     * WILL CHANGE: actual return type will be CompositeData OR Map
     *
     * @return Map containers keys from {@link MessageTrace}
     */
    public MessageTrace[] getMessagesInHistory();

    /**
     * Reset all the statistics
     */
    public void resetStats();

    /**
     * Returns last reset timestamp in milliseconds.
     *
     * @return  last reset timestamp in milliseconds
     */
    public long getLastResetTime();

}
