/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/j2ee/statistics/Attic/StatisticImpl.java,v 1.5 2005/12/25 03:50:56 tcfujii Exp $
 * $Revision: 1.5 $
 * $Date: 2005/12/25 03:50:56 $
 */

package com.sun.appserv.management.j2ee.statistics;

import java.io.Serializable;
import java.util.Map;

import javax.management.j2ee.statistics.Statistic;

import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.appserv.management.util.misc.ObjectUtil;
import com.sun.appserv.management.util.j2ee.stringifier.StatisticStringifier;
import com.sun.appserv.management.util.j2ee.J2EEUtil;


/**
	Implementation of Statistic which records its values in member
	variables.
 */
public class StatisticImpl implements Statistic, Serializable
{
	static final long serialVersionUID = -8120492090789878204L;
	
	/* members names as defined by JSR 77 */
	
	private final String	mName;
	private final String	mDescription;
	private final String	mUnit;
	protected long		mLastSampleTime;
	private final long		mStartTime;
	
		public
	StatisticImpl( 
		final String	name,
		final String	description,
		final String	unit,
		final long		startTime,
		final long		lastSampleTime )
	{
		mName	= name;
		mDescription	= description;
		mUnit	= unit;
		mLastSampleTime	= lastSampleTime;
		mStartTime	= startTime;
	}
	
		public
	StatisticImpl( final Statistic s )
	{
		mName			= s.getName();
		mDescription		= s.getDescription();
		mUnit			= s.getUnit();
		mLastSampleTime	= s.getLastSampleTime();
		mStartTime		= s.getStartTime();
	}
	
	/**
		Get the description for this Statistic
	 */
 		public String
 	getDescription()
 	{
 		return( mDescription );
 	}
 	
	
	/**
		Get the last sample time for this Statistic
	 */
 		public long
 	getLastSampleTime()
 	{
 		return( mLastSampleTime );
 	}
 	
	/**
		Get the name of this Statistic
	 */
		public String
	getName()
	{
 		return( mName );
	}
	
	/**
		Get the start time for this Statistic
	 */
		public long
	getStartTime()
	{
 		return( mStartTime );
	}
	
	
	/**
		Get the units associated with this statistic.
	 */
		public String
	getUnit()
	{
 		return( mUnit );
	}
	
		public String
	toString()
	{
		return StatisticStringifier.DEFAULT.stringify( this );
	}
	
	
 	    public int
 	hashCode()
 	{
 	    return ObjectUtil.hashCode( mName, mDescription, mUnit) ^
 	            ObjectUtil.hashCode( mLastSampleTime ) ^
 	            ObjectUtil.hashCode( mStartTime );
 	}
	
		public boolean
	equals( final Object rhs )
	{
		boolean	equals	= false;
		
		if ( rhs instanceof Statistic )
		{
			final Statistic	s	= (Statistic)rhs;
			
			equals	= getName().equals( s.getName() ) &&
						getUnit().equals( s.getUnit() ) &&
						getDescription().equals( s.getDescription() ) &&
						getStartTime() == s.getStartTime() &&
						getLastSampleTime() == s.getLastSampleTime();
		}
		return( equals );
	}
	
}





