/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.util.jmx;

import java.util.Set;
import java.util.Collections;

import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.misc.GSetUtil;

/**
	A mapper that maps every name to itself.
 */
public final class NoOpAttributeNameMapper implements AttributeNameMapper
{
	final Set<String>	mAttributeSet;
	
	/**
		Create a new instance which will map (as necessary) the specified
		Attribute names.
		Same as AttributeNameMapperImpl( attributeNames, new AttributeNameManglerImpl() )
	 */
		public
	NoOpAttributeNameMapper( final String[] originalNames )
	{
		mAttributeSet	= GSetUtil.newStringSet( originalNames );
	}
	

        public String
	matchName(
	    final String   derivedName,
	    final String[] candidates )
	{
	    throw new UnsupportedOperationException( "matchName" );
	}
	
		public void
	dontMap( final String originalName )
	{
		addMapping( originalName, originalName );
	}
	
		public void
	deriveAll( final String[] originalNames )
	{
		GSetUtil.addArray( mAttributeSet, originalNames );
	}
	
		public void
	addMapping(
		final String originalName,
		final String derivedName )
	{
		if ( ! originalName.equals( derivedName ) )
		{
			throw new IllegalArgumentException( derivedName );
		}
		
		mAttributeSet.add( originalName );
	}
	
		public boolean
	requiresMapping( final String originalName )
	{
		return( false );
	}
	
		public String
	originalToDerived( final String originalName )
	{
		return( originalName );
	}
	
		public String
	derivedToOriginal( final String derivedName )
	{
		return( derivedName );
	}
	
		public Set<String>
	getAttributeNames( )
	{
		return( Collections.unmodifiableSet( mAttributeSet ) );
	}
}
