/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.util.jmx.stringifier;

import javax.management.AttributeChangeNotification;

import com.sun.appserv.management.util.stringifier.Stringifier;
import com.sun.appserv.management.util.stringifier.SmartStringifier;


public class AttributeChangeNotificationStringifier
				extends NotificationStringifier implements Stringifier
{
	public static final AttributeChangeNotificationStringifier	DEFAULT	=
			new AttributeChangeNotificationStringifier();
	
		public
	AttributeChangeNotificationStringifier( )
	{
		super();
	}
	
		public
	AttributeChangeNotificationStringifier( Options options )
	{
		super( options );
	}
	
		public String
	stringify( Object o )
	{
		final AttributeChangeNotification	notif	= (AttributeChangeNotification)o;
		
		final StringBuffer	b	= super._stringify( notif );
		append( b, "" );
		
		final String	attrName	= notif.getAttributeName();
		final String	oldValue	= SmartStringifier.toString( notif.getOldValue() );
		final String	newValue	= SmartStringifier.toString( notif.getNewValue() );
		
		final String msg	= attrName + ": " + oldValue + " => " + newValue;
		b.append( msg );
		
		return( b.toString() );
	}
}



















