/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.util.misc;

import java.io.PrintStream;


/**
 */
public final class DebugSinkImpl implements DebugSink
{
    private final PrintStream   mPrintStream;
    
        public
    DebugSinkImpl( final PrintStream out )
    {
        mPrintStream    = out;
    }
    
	    public void
	print( final Object o  )
	{
	    mPrintStream.print( "" + o );
	}
	
	    public void
	println( Object o )
	{
	    mPrintStream.println( "" + o );
	}
}


