/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/util/misc/Attic/ValuePersister.java,v 1.3 2005/12/25 03:51:56 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:51:56 $
 */
package com.sun.appserv.management.util.misc;

/**
	Interface useful for persisting values using String.
	
	Implementors of this interface must be able to convert the value
	to a String and convert a String to its corresponding Object.
 */
public interface ValuePersister
{
	/**
		Convert the Object to a String representation
		
		@param value
		@return	a String representation of the Object
	 */
	public String	asString( Object value );
	
	/**
		Convert the String to a corresponding Object
		
		@param theString	the String to use
		@return	the corresponding Object representation
	 */
	public Object	asObject( String theString );
}
