/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 * PWCThreadPoolStats.java
 *
 * Created on April 2, 2004, 10:19 AM
 */

package com.sun.enterprise.admin.monitor.stats;

/**
 *
 * @author  nsegura
 */
import javax.management.j2ee.statistics.Stats;
import javax.management.j2ee.statistics.CountStatistic;
import com.sun.enterprise.admin.monitor.stats.StringStatistic;

/** 
 * Returns the statistical information associated with 
 * the HttpService thread pool 
 */
public interface PWCThreadPoolStats extends Stats {
    
    /** 
     * Returns the thread pool Id
     * @return id
     */    
    public StringStatistic getId();
    
    /** 
     * Returns the number of threads that are currently idle
     * @return idle threads
     */    
    public CountStatistic getCountThreadsIdle();
    
    /** 
     * Returns current number of threads
     * @return current threads
     */    
    public CountStatistic getCountThreads();
    
    /** 
     * Returns the maximum number of native threads allowed in the thread pool
     * @return max number of threads allowed
     */    
    public CountStatistic getMaxThreads();
    
    /** 
     * Returns the current number of requests waiting for a native thread
     * @return queued requests
     */    
    public CountStatistic getCountQueued();
    
    /** 
     * Returns the highest number of requests that were ever queued up
     * simultaneously for the use of a native thread since the server
     * was started
     */    
    public CountStatistic getPeakQueued();
    
    /** 
     * Returns the maximum number of requests that can be queued at one
     * time to wait for a native thread
     * @return max number of request to be queued
     */    
    public CountStatistic getMaxQueued();
    
}
