/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 * $Id: StatisticImpl.java,v 1.2 2005/12/25 03:52:26 tcfujii Exp $
 * $Date: 2005/12/25 03:52:26 $
 * $Revision: 1.2 $
 */

package com.sun.enterprise.admin.monitor.stats;
import javax.management.j2ee.statistics.Statistic;
import java.io.Serializable;
import com.sun.enterprise.util.i18n.StringManager;

/**
 * An abstract class providing implementation of the Statistic interface
 * The intent is for this to be subclassed by all the StatisticImpls.
 * @author Muralidhar Vempaty
 * @since S1AS8.0
 * @version 1.0
 */

public abstract class StatisticImpl implements Statistic,Serializable {
    
    private String statisticName;
    private String statisticDesc;
    private String statisticUnit;
    private long startTime;
    private long sampleTime;
    
	/** DEFAULT_UNIT is an empty string */
	public static String	DEFAULT_UNIT = null;
    public static StringManager localStrMgr = null;
	/** DEFAULT_VALUE of any statistic is 0 */
	public static final long	DEFAULT_VALUE	= java.math.BigInteger.ZERO.longValue();

    static {
        localStrMgr = StringManager.getManager(StatisticImpl.class);
        DEFAULT_UNIT = localStrMgr.getString("count_string");
    }

    /** 
     * Constructor
     * @param name      The name of the statistic
     * @param unit      The unit of measurement for this statistic
     * @param desc      A brief description of the statistic
     * @param startTime Time in milliseconds at which the measurement was started
     * @param sampleTime Time at which the last measurement was done.
     **/
    protected StatisticImpl(String name, String unit, String desc, 
                          long start_time, long sample_time) {
        
        statisticName = name;
        statisticUnit = unit;
        statisticDesc = desc;
        startTime = start_time;
        sampleTime = sample_time;
    }
    
    /**
     * returns the name of the statistic
     */
    public String getName() {
        return this.statisticName;
    }
    
    /**
     * returns the description of the statistic
     */
    public String getDescription() {
        return this.statisticDesc;
    }
    
    /**
     * returns the unit of measurement for the statistic
     */
    public String getUnit() {
        return this.statisticUnit;
    }
    
    /**
     * returns the time in millis, at which the last measurement was taken
     */
    public long getLastSampleTime() {
        return this.sampleTime;
    }
    
    /**
     * returns the time in millis, at which the first measurement was taken
     */
    public long getStartTime() {
        return this.startTime;
    }

    /** This is a hack. This method allows us to internatinalize the descriptions.
        See bug Id: 5045413
    */
    public void setDescription(final String desc) {
        this.statisticDesc = desc;
    }
}
