/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 * GeneratedMonitoringMBeanTest.java
 *
 * Created on August 7, 2003, 10:42 AM
 */

package com.sun.enterprise.admin.monitor.registry.spi;

import junit.framework.*;
import javax.management.j2ee.statistics.Stats;
import javax.management.*;
import java.util.*;

/**
 * Unit Test for testing GeneratedMonitoringMBean that gets created through the process of
 * transforming a JSR77 Stats object into a Dynamic MBean. The transformation is
 * helped by the ManagedResourceIntrospector which has its own tests.
 * @author  sg112326
 */
public class GeneratedMonitoringMBeanTest extends TestCase{
    
    public void testGetAttributeWithNull(){
        try{
            Enumeration e = attributes.keys();
            while(e.hasMoreElements()){
                Object n = mbean.getAttribute(null);
                try{
                    assertEquals(Long.class, n.getClass());
                }
                catch(Error ex){
                    ex.getLocalizedMessage();
                    assertEquals(String.class, n.getClass());
                }
            }
        }
        catch(Exception ex){
            assertEquals(NullPointerException.class, ex.getClass());
        }
    }
    
    public void testGetAttributeWithIncorrectAttrName(){
        try{
            Enumeration e = attributes.keys();
            while(e.hasMoreElements()){
                String elem = (String)e.nextElement();
                Object n = mbean.getAttribute(elem+"o");
                try{
                    assertEquals(Long.class, n.getClass());
                }
                catch(Error ex){
                    ex.getLocalizedMessage();
                    assertEquals(String.class, n.getClass());
                }
            }
        }
        catch(Exception ex){
            assertEquals(AttributeNotFoundException.class, ex.getClass());
        }
    }
    
    public void testGetAttributeWithCorrectAttrName(){
        try{
            Enumeration e = attributes.keys();
            while(e.hasMoreElements()){
                String elem = (String)e.nextElement();
                Object n = mbean.getAttribute(elem);
                try{
                    assertEquals(Long.class, n.getClass());
                }
                catch(Error ex){
                    ex.getLocalizedMessage();
                    assertEquals(String.class, n.getClass());
                }
            }
        }
        catch(Exception ex){
            assertEquals(NullPointerException.class, ex.getClass());
        }
    }
    public void testAtrributes(){
        Enumeration en = attributes.elements();
        while(en.hasMoreElements()){
            String attr = (String)en.nextElement();
            System.out.println("testing attribute:"+attr);
            try{ assertEquals("HeapSize", attr.substring(0,attr.indexOf("_")));
            }catch(Error ex){
                try{assertEquals("MaxMemory",attr.substring(0,attr.indexOf("_")));
                }catch(Error e){
                    try{assertEquals("UpTime",attr.substring(0,attr.indexOf("_")));
                    }catch(Error e1){
                        assertEquals("AvailableProcessors",attr.substring(0,attr.indexOf("_")));
                    }
                }
            }
        }
    }
    
    public void testCreation(){
        assertNotNull(mbean);
        assertNotNull(m);
        assertNotNull(jvm);
        assertNotNull(attrs);
    }
    /** Creates a new instance of GeneratedMonitoringMBeanTest */
    public GeneratedMonitoringMBeanTest(java.lang.String testName) {
        super(testName);
    }
    GeneratedMonitoringMBeanImpl mbean;
    S1ASJVMStatsImplMock jvm;
    MBeanInfo m;
    MBeanAttributeInfo[] attrs;
    Hashtable attributes = new Hashtable();
    
    protected void setUp() {
        jvm = new S1ASJVMStatsImplMock();
        mbean = new GeneratedMonitoringMBeanImpl(jvm);
        m = mbean.introspect();
        attrs = m.getAttributes();
        for(int i=0; i< attrs.length;i++){
            attributes.put(attrs[i].getName(),attrs[i].getName());
        }
    }
    
    protected void tearDown() {
        
    }
    
    public static Test suite() {
        TestSuite suite = new TestSuite(GeneratedMonitoringMBeanTest.class);
        return suite;
    }
    
    public static void main(String[] args){
        junit.textui.TestRunner.run(suite());
    }
}
