/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 * ManagedResourceIntrospectorTest.java
 *
 * Created on August 7, 2003, 10:48 AM
 */

package com.sun.enterprise.admin.monitor.util;

import junit.framework.*;
import javax.management.j2ee.statistics.Stats;
import javax.management.j2ee.statistics.Statistic;
import javax.management.*;


/**
 * Unit Test for ManagedResourceIntrospector to test appropriateness of
 * introspection for the purposes of generating an MBeanInfo Object
 * @author  sg112326
 */
public class ManagedResourceIntrospectorTest extends TestCase {
    public void testIntrospection(){
        MBeanInfo info = mri.introspect(stats);
        assertNotNull(info);
        assertEquals(mbean.getClass().getName(), info.getClassName());
    }

    public void testGetParameterInfoWithNull(){
        Class[] paramTypes = new Class[]{};
        MBeanParameterInfo[] info = mri.getParameterInfo(paramTypes);
        assertEquals(paramTypes.length, info.length);  
    }
    
    public void testGetParameterInfo(){
        Class[] paramTypes = new Class[]{java.lang.String.class, java.lang.Integer.class, 
            javax.management.j2ee.statistics.Statistic.class};
        MBeanParameterInfo[] info = mri.getParameterInfo(paramTypes);
        assertEquals(paramTypes.length, info.length);
    }
    
    public void testGetAttributeInfoWithNull(){
        MBeanAttributeInfo[] info = mri.getAttributeInfo(null);
        this.assertNull(info);
    }
    
    public void testGetAttributeInfo(){
        MBeanAttributeInfo[] info = mri.getAttributeInfo(stats);
        assertNotNull(info);
        assertEquals(28, info.length);
    }
    
    public void testCreation(){
        assertNotNull(mbean);
        assertNotNull(mri);
        assertNotNull(stats);
    }

    /** Creates a new instance of ManagedResourceIntrospectorTest */
    public ManagedResourceIntrospectorTest(java.lang.String testName) {
        super(testName);
    }

    DynamicMBean mbean=null;
    ManagedResourceIntrospector mri=null; 
    Stats stats;
    protected void setUp() {
        mbean = new GeneratedMonitoringMBeanImpl();
        mri = new ManagedResourceIntrospector(mbean);
        stats = new S1ASJVMStatsImplMock();
    }
    
    protected void tearDown() {
        
    }
    public static Test suite() {
        TestSuite suite = new TestSuite(ManagedResourceIntrospectorTest.class);
        return suite;
    }
    
    public static void main(String[] args){
        junit.textui.TestRunner.run(suite());
    }
}
