/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.admingui.descriptors;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.view.BasicCommandField;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;

import com.sun.web.ui.model.CCBreadCrumbsModel;
import com.sun.web.ui.model.CCBreadCrumbsModelInterface;
import com.sun.web.ui.view.breadcrumb.CCBreadCrumbs;

import com.sun.enterprise.tools.admingui.tree.IndexTreeNode;
import com.sun.enterprise.tools.admingui.util.Util;
import com.sun.enterprise.tools.admingui.ConfigProperties;
import com.sun.enterprise.tools.guiframework.event.descriptors.EventDescriptor;
import com.sun.enterprise.tools.guiframework.event.descriptors.HandlerDescriptor;
import com.sun.enterprise.tools.guiframework.event.descriptors.UseHandlerDescriptor;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.descriptors.BasicCommandFieldDescriptor;
import com.sun.enterprise.tools.guiframework.view.descriptors.FakeContainerDescriptor;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;


/**
 *
 *  @author	Garrett Short, garrett.short@sun.com
 *  @author	Ken Paulsen, ken.paulsen@sun.com
 */
public class CCBreadCrumbsDescriptor extends ViewDescriptor implements FakeContainerDescriptor {

    /**
     *	Default constructor
     */
    public CCBreadCrumbsDescriptor() {
	this(BREADCRUMB);
    }


    /**
     *	Constructor w/ name
     */
    public CCBreadCrumbsDescriptor(String name) {
	super(name);
    }


    /**
     *	This is a factory method for CCBreadCrumbs instances.
     *
     *	@param	ctx	The RequestContext
     *	@param	container	The container for the newly created
     */
    public View getInstance(RequestContext ctx, ContainerView container, String name) {
	return new CCBreadCrumbs(container, getModel(), name);
    }


    /**
     *
     */
    public void registerChildren(ContainerViewBase instance) {
	// Invoke the super registerChild
	// NOTE: Not a real container, but may have child descriptors
	super.registerChildren(instance);

	// create the model
	int numberOfCrumbs = getNumberOfBreadCrumbs(
	    instance.getParentViewBean().getRequestContext());
	for (int i=0; i<numberOfCrumbs; i++) {
	    instance.registerChild(CHILD_BREADCRUMB_LINK+i, BasicCommandField.class);
	}
    }


    /**
     *	This method returns the number of links in the bread crumb.
     */
    public int getNumberOfBreadCrumbs(RequestContext ctx) {
	CCBreadCrumbsModelInterface model = getModel(ctx);
	if (model == null) {
	    return 0;
	}

	// getNumRows() is not defined in any interface
	return ((DefaultModel)model).getNumRows();
    }


    /**
     *	This method provides access to the Model using the ModelManager.  It
     *	also populates the model with all the links.  Note: the Model Manager
     *	key is equal to node.getPath() ensuring that Models that have different
     *	node path will be different Models.
     *
     *	@return	The CCBreadCrumbsModelInterface
     */
    public CCBreadCrumbsModelInterface getModel() {
	RequestContext rc = RequestManager.getRequestContext();
	return getModel(rc);
    }


    /**
     *	This method provides access to the Model using the ModelManager.  It
     *	also populates the model with all the links.  Note: the Model Manager
     *	key is equal to node.getPath() ensuring that Models that have different
     *	node path will be different Models.
     *
     *	@param	rc	The RequestContext
     *
     *	@return	The CCBreadCrumbsModelInterface
     */
    protected CCBreadCrumbsModelInterface getModel(RequestContext rc) {
	// Get the current/selected tree node
	IndexTreeNode node = Util.getSelectedNode();

	// Use the ModelManager to get/create the CCBreadCrumbsModel
	// NOTE: This will not set the current node
	CCBreadCrumbsModelInterface model = (CCBreadCrumbsModelInterface)
	    rc.getModelManager().getModel(CCBreadCrumbsModelInterface.class,
		node.getPath(), false, false);

	// If the current page label is set, then we've already initialized it
	// (we know we have the right one because the Model Manager uses the
	// "name" to register it).
	if (model.getCurrentPageLabel() != null) {
	    // current model is still valid, return it, else init it
	    return model;
	}
        
	// Initialize the model
	model.setCurrentPageLabel(node.getDisplayName());

	// Fill the stack w/ the node parents (skip the bottom and top node)
	Stack stack = getNodeStack(node);

	// Cast to DefaultModel b/c appendRow is not part of any interface
	DefaultModel defModel = (DefaultModel)model;
        
	int crumbCount = 0;
	while (!stack.empty()) {
	    node = (IndexTreeNode)stack.pop();
	    defModel.appendRow();
	    defModel.setValue(
		CCBreadCrumbsModel.COMMANDFIELD,
		CHILD_BREADCRUMB_LINK+crumbCount++);
	    defModel.setValue(CCBreadCrumbsModel.LABEL, node.getDisplayName());
	    defModel.setValue(CCBreadCrumbsModel.MOUSEOVER, node.getDisplayName());
	}

	// Return the model
	return model;
    }


    /**
     *	This method is overriden because there are pre-request children that
     *	cannot be cached.
     */
    public List getChildDescriptors() {
    	// Get the "real" children (probably none)
	List descs = new ArrayList(super.getChildDescriptors());

	// Add the virtual children
	Stack stack = getNodeStack(Util.getSelectedNode());
	for (int count=0; !stack.empty(); count++) {
	    descs.add(createChildBreadCrumbDescriptor(
		CHILD_BREADCRUMB_LINK+count, (IndexTreeNode)stack.pop()));
	}

	return descs;
    }


    /**
     *	Creates a Stack full of IndexTreeNode.  The top of the stack is the top
     *	most -1 of the tree.  The bottom of the stack is the parent of the
     *	current node.
     *
     *	@param	node	The IndexTreeNode to start with (won't be in Stack)
     *
     *	@return Stack of IndexTreeNode
     */
    protected Stack getNodeStack(IndexTreeNode node) {
	// Fill the stack w/ the node parents (skip the bottom and top node)
	Stack stack = new Stack();
	for (node=node.getParent(); (node != null); node=node.getParent()) {
            String include = (String)node.getAttribute("includeInBreadCrumb", false);
            if (include != null && include.equals("false"))
                continue;
	    stack.push(node);
	}

	return stack;
    }


    /**
     *	This method is overriden because there are pre-request children that
     *	cannot be cached.
     */
    public ViewDescriptor getChildDescriptor(String name) {
	// Can't call super b/c it will call getChildDescriptors and get the
	// ones we don't want to be stored in a Map.
	// super.getChildDescriptors() is ok to call

	// First check to see if its a virtual descriptor
	if (name.startsWith(CHILD_BREADCRUMB_LINK)) {
	    // Get the link #
	    int linkNum = 0;
	    try {
		linkNum = Integer.parseInt(name.substring(CHILD_BREADCRUMB_LINK.length()));
	    } catch (NumberFormatException ex) {
		throw new FrameworkException(
		    "Could not determine link number of: "+name,
		    ex, this, null);
	    }

	    // Get the IndexTreeNode Stack
	    Stack stack = getNodeStack(Util.getSelectedNode());

	    // Get the node associated with this link.  List order is reverse,
	    // so use size-index-1 to get the List index.
	    // This may throw array bound exception, that's ok
	    IndexTreeNode node = (IndexTreeNode)
		stack.get(stack.size()-linkNum-1);

	    // If the last line didn't throw an exception, then they are
	    // requesting a valid bread crumb -- create it.
	    return createChildBreadCrumbDescriptor(name, node);
	}

	// Not a virutal descriptor... then maybe a different child (unlikely)
	// Must use super.getChildDescriptors() vs.
	// super.getChildDescriptor(String) in order to avoid adding virtual
	// descriptors to super's Map.
	ViewDescriptor desc = null;
	Iterator iter = super.getChildDescriptors().iterator();
	while (iter.hasNext()) {
	    desc = (ViewDescriptor)iter.next();
	    if (desc.getName().equals(name)) {
		return desc;
	    }
	}

	// Not found. :(
	return null;
    }


    /**
     *	This method dynamically adds a child descriptor to accomodate a dynamic
     *	number of links.
     */
    protected ViewDescriptor createChildBreadCrumbDescriptor(String name, IndexTreeNode node) {
	ViewDescriptor desc = new BasicCommandFieldDescriptor(name);

	// set the tree node for simulating a click...
	desc.addParameter("treeNode", node.getPath());

	// Create an Event Descriptor for handling the "click"
	EventDescriptor event = new EventDescriptor(desc, EventDescriptor.TYPES.COMMAND);
	event.addEventHandler(new UseHandlerDescriptor(desc, CLICK_HANDLER));
	desc.setEventDescriptor(event);
        desc.setParent(this);

	// Return the new ViewDescriptor
	return desc;
    }


    // this name must be used in the JSP files
    public static final String BREADCRUMB		= "BreadCrumb"; 
    public static final String CHILD_BREADCRUMB_LINK	= "BreadCrumbLink";

    public static HandlerDescriptor CLICK_HANDLER;
    static {
	CLICK_HANDLER = new HandlerDescriptor("BreadCrumbHandler");
	CLICK_HANDLER.setHandlerMethod(
	    "com.sun.enterprise.tools.admingui.handlers.BreadCrumbHandler",
	    "handleClick");
    }

    private CCBreadCrumbsModel _model = null;
}
