/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.admingui.descriptors;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.view.BasicDisplayField;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;

import com.sun.enterprise.tools.guiframework.event.descriptors.EventDescriptor;
import com.sun.enterprise.tools.guiframework.FrameworkDescriptor;
import com.sun.enterprise.tools.guiframework.event.descriptors.EventDescriptor;
import com.sun.enterprise.tools.guiframework.event.descriptors.HandlerDescriptor;
import com.sun.enterprise.tools.guiframework.event.descriptors.IODescriptor;
import com.sun.enterprise.tools.guiframework.event.descriptors.UseHandlerDescriptor;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import com.sun.enterprise.tools.guiframework.view.descriptors.DisplayFieldDescriptor;
import com.sun.enterprise.tools.guiframework.util.Util;

/**
 *
 */
public class ExtendedTextFieldDescriptor extends DisplayFieldDescriptor {

    /**
     *
     */
    public ExtendedTextFieldDescriptor(String name) {
	super(name);
        //addBeginDisplayHandler(this);
        addEndDisplayHandler(this);
    }
    
//  Added this to the framework..........
//    private void addBeginDisplayHandler(ViewDescriptor desc) {
//        EventDescriptor ev = desc.getEventDescriptor(EventDescriptor.TYPES.BEGIN_DISPLAY);
//        if (ev == null)
//            ev = new EventDescriptor(desc, EventDescriptor.TYPES.BEGIN_DISPLAY);
//        
//        HandlerDescriptor hd = new HandlerDescriptor("beginExtendedTextDisplay");
//        hd.setHandlerMethod(
//            "com.sun.enterprise.tools.admingui.handlers.SystemPropsHandlers", 
//            "beginExtendedTextDisplay");
//
//        UseHandlerDescriptor useDesc =  new UseHandlerDescriptor(ev, hd);
//        ev.addEventHandler(useDesc);
//        desc.setEventDescriptor(ev);
//    }

    private void addEndDisplayHandler(ViewDescriptor desc) {
        EventDescriptor ev = desc.getEventDescriptor(EventDescriptor.TYPES.END_DISPLAY);
        if (ev == null) 
            ev = new EventDescriptor(desc, EventDescriptor.TYPES.END_DISPLAY);
        
        HandlerDescriptor hd = new HandlerDescriptor("endExtendedTextDisplay");
        hd.setHandlerMethod(
            "com.sun.enterprise.tools.admingui.handlers.SystemPropsHandlers", 
            "endExtendedTextDisplay");

        UseHandlerDescriptor useDesc =  new UseHandlerDescriptor(ev, hd);
        ev.addEventHandler(useDesc);
        desc.setEventDescriptor(ev);
    }

    /**
     *	This is a factory method for BasicDisplayField instances.  It uses the
     *	DisplayField DEFAULT_VALUE ("defaultValue") parameter for setting its
     *	initial value.
     *
     *	@param	ctx		The RequestContext
     *	@param	container	The container for the new BasicDisplayField
     */
    public View getInstance(RequestContext ctx, ContainerView container, String name) {
	BasicDisplayField field = new BasicDisplayField(container, name);

	// Set the default value if supplied
	setDefaultValue(field);

	return field;
    }
}
