/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * CommonHandlers.java
 *
 */

package com.sun.enterprise.tools.admingui.handlers;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.StringTokenizer;
import java.util.Properties;
import java.util.Enumeration;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestContextImpl;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.Model;
import com.iplanet.jato.util.RootCauseException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.DisplayFieldImpl;
import com.iplanet.jato.view.ViewBase;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.html.SelectableGroup;
import com.iplanet.jato.view.html.OptionList;

import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.AttributeList;
import javax.management.Attribute;
import javax.servlet.ServletRequest;

import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.model.ModelManager;
import com.sun.enterprise.tools.guiframework.view.DescriptorCCPageTitle;
import com.sun.enterprise.tools.guiframework.view.DescriptorContainerView;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import com.sun.enterprise.tools.guiframework.view.descriptors.CCActionTableDescriptor;
import com.sun.enterprise.tools.guiframework.view.event.BeforeCreateEvent;
import com.sun.enterprise.tools.guiframework.view.event.ErrorEvent;

import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.model.CCActionTableModel;

import com.sun.enterprise.tools.admingui.util.MBeanUtil;
import com.sun.enterprise.tools.admingui.util.Util;
import com.sun.enterprise.tools.admingui.tree.IndexTreeNode;
import com.sun.enterprise.tools.admingui.tree.IndexTreeModelImpl;
import com.sun.enterprise.tools.admingui.tree.IndexTreeModel;


/**
 *
 */
public class ConnectorHandlers {

    public static final String  PROP_MODEL	= "property.model";
    public static final String  PROP_CHILD	= "property.child";
    public static final String	PROPERTY_NAME	= "propertyName";
    public static final String	PROPERTY_VALUE 	= "propertyValue";


    /**
     *
     */
    public void populateDropdown(RequestContext ctx, HandlerContext handlerCtx) {
	View view = handlerCtx.getView();
        // the child should be something like: com.sun.web.ui.view.html.CCDropDownMenu
        SelectableGroup dropDownChild = (SelectableGroup) view;
        // get the parent container of the dropdown
        DescriptorContainerView parent = (DescriptorContainerView) dropDownChild.getParent();

        // need the child descriptor to get a parameter, retrieve from the parent descriptor.
        ViewDescriptor vd = parent.getViewDescriptor();
        ViewDescriptor cvd = vd.getChildDescriptor(dropDownChild.getName());
        // the method name is specified in the XML file.

	String methodName = (String)ctx.getRequest().getAttribute("dropDownMethodName");
	String objectName   = (String)ctx.getRequest().getAttribute("dropDownObjectName");
	String attr   = (String)ctx.getRequest().getAttribute("dropDownAttributeName");
	if (attr == null) {
	    throw new FrameworkException("attribute is null", cvd, view);
	}
	ctx.getRequest().setAttribute("rarName", attr);
        Object[] params = new Object[]{attr};

	if (objectName == null || methodName == null) {
	    throw new FrameworkException("objectName or methodName is null",
		cvd, view);
	}

        // and finally fill in the menu choices.
        dropDownChild.setLabelForNoneSelected("             ");
        String[] type = new String[]{"java.lang.String"};
	try {
	    Object keys = (Object) MBeanUtil.invoke(objectName, methodName, params, type);
            String[] choices = (String[])keys;
	    //String [] choices = {"a","b","c"};

	    OptionList dropDownMenuOptions = new OptionList(choices,choices); // label and values
	    dropDownChild.setOptions(dropDownMenuOptions);
	} catch (Exception ex) {
	    throw new FrameworkException(ex, cvd, view);
	}
    }


    /**
     *
     */
    public void populatePropsTableModel(RequestContext ctx, HandlerContext handlerCtx) {
	View view = handlerCtx.getView();
	if (!(handlerCtx.getEvent() instanceof BeforeCreateEvent)) {
	    ViewDescriptor desc = (view instanceof DescriptorContainerView) ?
		((DescriptorContainerView)view).getViewDescriptor() :
		(ViewDescriptor)null;
	    throw new FrameworkException("This handler is for 'beforeCreate'" +
		" handlers only!", desc, view);
	}
	ViewDescriptor desc = ((BeforeCreateEvent)handlerCtx.getEvent()).getViewDescriptor();
	try {
            if (desc instanceof CCActionTableDescriptor) {
		CCActionTableDescriptor ccDesc = (CCActionTableDescriptor)desc;
                loadProperties(ccDesc.getModel(), ctx);
	    }
        } catch (Exception ex) {
            throw new FrameworkException(ex, desc, view);
        }
    }

    /**
     *
     */
    public void populateAdminPropsTableModel(RequestContext ctx, HandlerContext handlerCtx) {
	View view = handlerCtx.getView();
	if (!(handlerCtx.getEvent() instanceof BeforeCreateEvent)) {
	    ViewDescriptor desc = (view instanceof DescriptorContainerView) ?
		((DescriptorContainerView)view).getViewDescriptor() :
		(ViewDescriptor)null;
	    throw new FrameworkException("This handler is for 'beforeCreate'" +
		" handlers only!", desc, view);
	}
	ViewDescriptor desc = ((BeforeCreateEvent)handlerCtx.getEvent()).getViewDescriptor();
	try {
            if (desc instanceof CCActionTableDescriptor) {
		CCActionTableDescriptor ccDesc = (CCActionTableDescriptor)desc;
                adminLoadProperties(ccDesc.getModel(), ctx);
	    }
        } catch (Exception ex) {
            throw new FrameworkException(ex, desc, view);
        }
    }



    private void loadProperties(CCActionTableModelInterface model, RequestContext ctx) {
	ServletRequest req = ctx.getRequest();
	String methodName = (String)req.getAttribute("dropDownMethodName");
	String objectName   = (String)req.getAttribute("dropDownObjectName");
	String attr   = (String)req.getAttribute("rarName");
	String cd   = (String)req.getAttribute("connectionDefinition");
        //String cd = "javax.resource.cci.ConnectionFactory";
        //String attr = "comet";
	if (attr == null) {
	    throw new FrameworkException("attribute is null");
	}
 	if (cd == null) {
	    throw new FrameworkException("connection definition is null");
	}

        AttributeList attrList = new AttributeList();
        attrList.add(new Attribute("resource-adapter-name", attr));
        attrList.add(new Attribute("connection-definition-name", cd));
        Object[] params = new Object[]{attrList};

	if (objectName == null || methodName == null) {
	    throw new FrameworkException("objectName or methodName is null", null, null);
	}
        String[] type = new String[]{"javax.management.AttributeList"};

	Object keys = (Object)MBeanUtil.invoke(objectName, methodName, params, type);
        Properties props = (Properties)keys;

        if (props == null) {
            return; //nothing to load..
	}

	try {
            Enumeration enums = props.propertyNames();
            while(enums.hasMoreElements()){
                model.appendRow();
                String name = (String)enums.nextElement();
                String value = props.getProperty(name);
                model.setValue(PROPERTY_NAME, name);
                model.setValue(PROPERTY_VALUE, value);
            }
        } catch (Exception ex) {
	    throw new FrameworkException(ex);
	}
     }


    private void adminLoadProperties(CCActionTableModelInterface model, RequestContext ctx) {
	ServletRequest req = ctx.getRequest();
	String methodName = (String)req.getAttribute("dropDownMethodName");
	String objectName   = (String)req.getAttribute("dropDownObjectName");
	String attr   = (String)req.getAttribute("JndiName");
	String ra   = (String)req.getAttribute("connectorModule");
	if (attr == null) {
	    throw new FrameworkException("attribute is null");
	}
 	if (ra == null) {
	    throw new FrameworkException("connector Module is null");
	}

        AttributeList attrList = new AttributeList();
        attrList.add(new Attribute("resource-adapter-name", ra));
        attrList.add(new Attribute("admin_object_interface", attr));
        Object[] params = new Object[]{attrList};

	if (objectName == null || methodName == null) {
	    throw new FrameworkException("objectName or methodName is null", null, null);
	}
        String[] type = new String[]{"javax.management.AttributeList"};

	Object keys = (Object) MBeanUtil.invoke(objectName, methodName, params, type);
        Properties props = (Properties)keys;

        if (props == null) {
            return; //nothing to load..
	}

	try {
            Enumeration enums = props.propertyNames();
            while(enums.hasMoreElements()){
                model.appendRow();
                String name = (String)enums.nextElement();
                String value = props.getProperty(name);
                model.setValue(PROPERTY_NAME, name);
                model.setValue(PROPERTY_VALUE, value);
            }
        } catch (Exception ex) {
	    throw new FrameworkException(ex);
	}
     }
}
