/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.admingui.handlers;

import com.iplanet.jato.*;
import com.iplanet.jato.model.*;
import com.iplanet.jato.view.*;
import com.iplanet.jato.view.event.*;
import com.iplanet.jato.view.html.*;

import com.sun.web.ui.taglib.header.*;
import com.sun.enterprise.tools.guiframework.view.DescriptorContainerView;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;

import com.sun.enterprise.tools.admingui.tree.*;
import com.sun.enterprise.tools.admingui.util.Util;
import com.sun.enterprise.tools.admingui.util.MBeanUtil;

import java.util.EventObject;
import javax.management.ObjectName;

public class MastHeadHandlers {
    
    public String endReplaceHrefDisplay(RequestContext ctx, HandlerContext handlerCtx) {
        ChildContentDisplayEvent ev = (ChildContentDisplayEvent)handlerCtx.getEvent();
        String content = ev.getContent();
        
        String URL = (String)handlerCtx.getInputValue("URL");
        if (URL == null) 
            URL = "#";
        content = Util.addHtmlProp(Util.removeHtmlProp(content, "href"), "href=\""+URL+"\"");
        return content;
    }
    
    public String endRegistrationLinkDisplay(RequestContext ctx, HandlerContext handlerCtx) {
        ChildContentDisplayEvent ev = (ChildContentDisplayEvent)handlerCtx.getEvent();
        String content = ev.getContent();
        
        String URL = (String)handlerCtx.getInputValue("URL");
        if (URL == null) 
            URL = "#";
        content = Util.addHtmlProp(Util.removeHtmlProp(content, "href"), 
                                   "href=\""+ URL +"\" target=\"_blank\""); 
        return content;
    }
    
    public String endQuickStartLinkDisplay(RequestContext ctx, HandlerContext handlerCtx) {
    	 ChildContentDisplayEvent ev = (ChildContentDisplayEvent)handlerCtx.getEvent();
         String content = ev.getContent();
         String baseName = "com.sun.enterprise.tools.admingui.resources.Helplinks";
         
         String key = (String)handlerCtx.getInputValue("key");
         if (key == null) { 
             key = "QuickStartGuide";
         }
         String fileName = Util.getMessage(baseName, key, null, ctx.getRequest().getLocale());
         //We need the quickstart prefix to handle this request by the QuickStart servlet.
         fileName = "../quickstart/"+fileName;
         content = Util.addHtmlProp(Util.removeHtmlProp(content, "href"), 
                                    "href=\""+ fileName +"\" target=\"_blank\""); 
         return content;
    }

     public String endVersionLinkDisplay(RequestContext ctx, HandlerContext handlerCtx) {
        String openWindow;
        ChildContentDisplayEvent ev = (ChildContentDisplayEvent)handlerCtx.getEvent();
        String content = ev.getContent();
	//ServerInstGeneralHandlers serverInst = new ServerInstGeneralHandlers();
	//String version = serverInst.endInstallVersionDisplay(ctx, handlerCtx);
	
	openWindow = "../admingui/Version?&productNameSrc=../images/fullname.gif&"+
			"versionFile=../admingui/copyright&productNameHeight=56&"+
			"productNameWidth=400";
			
        content = Util.addHtmlProp(Util.removeHtmlProp(content, "href"), "href=\""+openWindow+"\"");
        return content;
    }
     
    public void versionTextDisplay(RequestContext ctx, HandlerContext handlerCtx) {
	View bean = handlerCtx.getView();
	BasicDisplayField version = (BasicDisplayField)bean;
	String versionText = ServerInstGeneralHandlers.endInstallVersionDisplay(ctx, handlerCtx);
	version.setValue(versionText);
	//System.out.println("PARENT VERSION = "+(Desbean.geParent().getClass());
    }
    
    public String endServerNameDisplay(RequestContext ctx, HandlerContext handlerCtx) {
	View bean = handlerCtx.getView();
        DescriptorContainerView view = (DescriptorContainerView)bean.getParent();
        return ctx.getRequest().getServerName();
    }
        
    public String endDomainNameDisplay(RequestContext ctx, HandlerContext handlerCtx) {
        String name = "";
        try {
            Object domain = MBeanUtil.invoke(
                new ObjectName("com.sun.appserv:type=domain,category=config"), "getName", null, null);
            name = domain.toString();
        } catch (Exception ex) {
	    if (Util.isLoggableINFO()) {
		Util.logINFO("Exception thrown in getting domaim name.", ex);
	    }
        }
        return name;
    }
        
    public String endUserNameDisplay(RequestContext ctx, HandlerContext handlerCtx) {
	View bean = handlerCtx.getView();
        DescriptorContainerView view = (DescriptorContainerView)bean.getParent();
        return ctx.getRequest().getRemoteUser();
    }
}
