/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
/*
 * WebServiceHandler.java
 *
 * Created on May 6, 2005, 12:27 PM
 */

package com.sun.enterprise.tools.admingui.handlers;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.text.NumberFormat;

import javax.servlet.http.HttpSession;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.html.OptionList;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBase;

import com.sun.enterprise.tools.admingui.util.MBeanUtil;
import com.sun.enterprise.tools.admingui.util.Util;
import com.sun.enterprise.tools.admingui.util.AMXUtil;

import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.DescriptorContainerView;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.enterprise.tools.guiframework.view.descriptors.CCActionTableDescriptor;
import com.sun.enterprise.tools.guiframework.view.descriptors.CCAddRemoveDescriptor;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import com.sun.enterprise.tools.guiframework.view.event.BeforeCreateEvent;

import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.model.CCAddRemoveModelInterface;
import com.sun.web.ui.taglib.pagetitle.CCPageTitleTag;
import com.sun.web.ui.view.addremove.CCAddRemove;


//AMX dynamic proxies
import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.QueryMgr;
import com.sun.appserv.management.config.EJBModuleConfig;
import com.sun.appserv.management.config.J2EEApplicationConfig;
import com.sun.appserv.management.config.RegistryLocationConfig;
import com.sun.appserv.management.config.TransformationRuleConfig;
import com.sun.appserv.management.config.WebModuleConfig;
import com.sun.appserv.management.config.WebServiceEndpointConfig;
import com.sun.appserv.management.ext.wsmgmt.WebServiceEndpointInfo;
import com.sun.appserv.management.ext.wsmgmt.WebServiceMgr;
import com.sun.appserv.management.j2ee.WebServiceEndpoint;

public class WebServiceHandler {
    
   public void loadWebServiceGeneralTableModel(RequestContext ctx, HandlerContext handlerCtx) {
       CCActionTableDescriptor ccDesc = (CCActionTableDescriptor)((BeforeCreateEvent)handlerCtx.getEvent()).getViewDescriptor();
       CCActionTableModelInterface model = ccDesc.getModel();
        ((DefaultModel)model).clear();
        
        ArrayList displayNamesList = (ArrayList)handlerCtx.getInputValue("displayNames");
        ArrayList modelNamesList = (ArrayList)handlerCtx.getInputValue("attributeNames");
        ObjectName webServiceMgr = (ObjectName)handlerCtx.getInputValue("webServiceMgrObjectName");
        String getWSNames = (String)handlerCtx.getInputValue("getWSNamesMethodName");
        Map wsNames = (Map)handlerCtx.getInputValue("wsNamesMap");
        String[] fullName = (String[])wsNames.keySet().toArray(new String[wsNames.size()]);
        
        if (wsNames == null || wsNames.isEmpty()) {
            return; //nothing to load..
        }
        
        String[] modelNames = null;
        if (modelNamesList != null) {
            modelNames = (String[])modelNamesList.toArray(new String[modelNamesList.size()]);
        }
         
        for (int i = 0; i < fullName.length; i++) {
            model.appendRow();
            Object[] paramsArray = {fullName[i]};
            String[] typesArray  = {"java.lang.Object"};
            Map wsiMap = (Map)MBeanUtil.invoke(webServiceMgr, getWSNames, paramsArray , typesArray);
            for (int j=0; j< modelNames.length; j++) {
                String col = (String)displayNamesList.get(j);
                Object obj = wsiMap.get(modelNames[j]);
                String val = "";
                if (obj instanceof String) {
                    val = (String)obj;
                } else if (obj instanceof Boolean) {
                    val = obj.toString();
                }
                if (col.equals("name")) {
                    val = (String)wsNames.get(fullName[i]);  // get display name
                } else if (col.equals("wsdl")) {                
                    val = new File(val).getName();
                } else if (col.equals("webServiceKey")) {
                    val = fullName[i];
                }
                model.setValue(col, val);
            }
        }
    }
   
    public void loadMessagesTableModel(RequestContext ctx, HandlerContext handlerCtx) {
        CCActionTableModelInterface model = (CCActionTableModelInterface)handlerCtx.getInputValue("tableModel");
        ((DefaultModel)model).clear();
        
        ArrayList displayNamesList = (ArrayList)handlerCtx.getInputValue("displayNames");
        ArrayList modelNamesList = (ArrayList)handlerCtx.getInputValue("attributeNames");
        Set epSet = (Set)handlerCtx.getInputValue("endpointObjNameSet");
        String filterValue = (String)handlerCtx.getInputValue("filterValue");
        if (filterValue == null) {
            filterValue = com.sun.web.ui.view.table.CCActionTable.FILTER_ALL_ITEMS_OPTION;
        }
        
        if (epSet == null || epSet.isEmpty()) {
            return; //no runtime endpoints to load
        }
        ObjectName endpointObjName = (ObjectName)epSet.toArray()[0];
        Map[] msgsMap = (Map[])MBeanUtil.getAttribute(endpointObjName, "MessagesInHistory");
        
        if (msgsMap == null || msgsMap.length == 0) {
            return; //nothing to load..
        }
        
        String[] modelNames = null;
        if (modelNamesList != null) {
            modelNames = (String[])modelNamesList.toArray(new String[modelNamesList.size()]);
        }
        
        String success = Util.getMessage("common.Success");
        String failed = Util.getMessage("common.Failed");
        
        for (int i=0; i < msgsMap.length; i++) {
            Object ob = msgsMap[i].get("FaultCode");
            if (ob == null && filterValue.equals("Success")   //match the value in the table xml
            || ob != null && filterValue.equals("Failed")
            || filterValue.equals(com.sun.web.ui.view.table.CCActionTable.FILTER_ALL_ITEMS_OPTION)) {
           
                model.appendRow();
                
                for (int j=0; j< modelNames.length; j++) {
                    String col = (String)displayNamesList.get(j);
                    Object obj = msgsMap[i].get(modelNames[j]);
                    String val = "";
                    if (obj instanceof String) {
                        val = (String)obj;
                    } else if (obj instanceof Integer) {
                        val = obj.toString();
                    }
                    if (col.equals("timeStampFormatted")) {
                        Long L = new Long(val);
                        long l = L.longValue();
                        java.util.Date date = new java.util.Date(l);
                        val = date.toString();
                    } else if (col.equals("size")) {
                        val = msgsMap[i].get("RequestSize") + "b / " + msgsMap[i].get("ResponseSize") + "b";
                    } else if (col.equals("response")) {
                        val = obj == null ? success : failed;
                    } else if (col.endsWith("endpointObjName")) {
                        val = endpointObjName.toString();
                    } else if (col.endsWith("callFlow")) {
                        String callFlow = (String)msgsMap[i].get("CallFlowEnabled");
                        Boolean isCallFlowEnabled = Boolean.valueOf(callFlow);
                        if (isCallFlowEnabled) {
                            val = Util.getMessage("webServiceMessages.callFlow");
                        } else {
                            val = "";
                        }
                    }
                    model.setValue(col, val);
                }
            }
        }
    }
    
    public void getMsgContent(RequestContext ctx, HandlerContext handlerCtx) {
        String endpointObjName = (String)handlerCtx.getInputValue("endpointObjName");
        String msgID = (String)handlerCtx.getInputValue("msgID");
        String type = (String)handlerCtx.getInputValue("type");
        Map[] msgsMap = (Map[])MBeanUtil.getAttribute(endpointObjName, "MessagesInHistory");
        String content = null;
        for (int i=0; i < msgsMap.length; i++) {
            String id = msgsMap[i].get("MessageID").toString();
            if (id.equals(msgID)) {
                if (type.equals("request")) {
                    content = (String)msgsMap[i].get("RequestContent");
                } else {
                    content = (String)msgsMap[i].get("ResponseContent");
                }
                break;
            }
        }
        handlerCtx.setOutputValue("content", content);
    }
    
    public void beginMsgViewerTitleDisplay(RequestContext ctx, HandlerContext handlerCtx) {
        CCPageTitleTag tag = (CCPageTitleTag)handlerCtx.getEvent().getSource();
        String type = (String)handlerCtx.getInputValue("type");
        String title = "";
        if (type.equals("request")) {
            title = Util.getMessage("webServiceMessageDetail.Request");
        } else {
            title = Util.getMessage("webServiceMessageDetail.Response");
        }
        tag.setPageTitleText(title);
    }
    
    public void getApplicationLinkNextPage(RequestContext ctx, HandlerContext handlerCtx) {
        String isStandAlone = (String)handlerCtx.getInputValue("isStandAlone");
        String type = (String)handlerCtx.getInputValue("type");
        if (isStandAlone.equals("false")) {
            handlerCtx.setOutputValue("nextPage", "enterpriseApplicationsEdit");
        } else {
            if (type.equals("SERVLET")) {
                handlerCtx.setOutputValue("nextPage", "webApplicationsEdit");
            } else {
                handlerCtx.setOutputValue("nextPage", "ejbModulesEdit");
            }
        }
    }
    
    public void displayWebServiceInfo(RequestContext ctx, HandlerContext handlerCtx) {
        ArrayList displayNamesList = (ArrayList)handlerCtx.getInputValue("displayNames");
        ArrayList modelNamesList = (ArrayList)handlerCtx.getInputValue("attributeNames");
        ObjectName webServiceMgr = (ObjectName)handlerCtx.getInputValue("webServiceMgrObjectName");
        String getWSNames = (String)handlerCtx.getInputValue("getWSNamesMethodName");
        String webServiceKey = (String)handlerCtx.getInputValue("webServiceKey");
        Map wsNames = (Map)handlerCtx.getInputValue("wsNamesMap");
        String displayName = (String)wsNames.get((Object)webServiceKey);
        String[] paramsArray = {webServiceKey};
        String[] typesArray  = {"java.lang.Object"};
        
        Map wsiMap = (Map)MBeanUtil.invoke(webServiceMgr, getWSNames, paramsArray , typesArray);

        String[] modelNames = null;
        if (modelNamesList != null) {
            modelNames = (String[])modelNamesList.toArray(new String[modelNamesList.size()]);
        }
  	DescriptorContainerView view = (DescriptorContainerView)handlerCtx.getView();
        String type = (String)wsiMap.get("ServiceImplType");

        for (int j=0; j< modelNames.length; j++) {
                String displayField = (String)displayNamesList.get(j);
                Object obj = wsiMap.get(modelNames[j]);
                String val = null;
                if (obj instanceof String) {
                    val = (String)obj;
                } else if (obj instanceof Boolean) {
                    val = obj.toString();
                }
                if (displayField.equals("name")) {
                    val = displayName;
                } else if (displayField.equals("wsdl")||displayField.equals("mapping")) {
                    if (val != null) {
                        val = new File(val).getName();
                    }
                } else if (displayField.equals("webservices")) {                
                    val = "webservices.xml";                    
                } else if (displayField.equals("j2eeDescriptor")) {
                    if (type.equals("SERVLET")) {
                        val = "web.xml";
                    } else {
                        val= "ejb-jar.xml";
                    }
                } else if (displayField.equals("sunDescriptor")) {
                    if (type.equals("SERVLET")) {
                        val = "sun-web.xml";
                    } else {
                        val = "sun-ejb-jar.xml";
                    }
                } else if (displayField.equals("implClass")) {
                    if (val == null) {
                        val = (String)wsiMap.get("ServiceImplName");
                    }
                }
               view.setDisplayFieldValue(displayField, val);
        }
       
    }
    
    public void getDeploymentDescriptorLocation(RequestContext ctx, HandlerContext handlerCtx) {
	String appName = (String)handlerCtx.getInputValue("application");
        String moduleName = (String)handlerCtx.getInputValue("moduleName");
        String isStandAlone = (String)handlerCtx.getInputValue("isStandAlone");
        String implType = (String)handlerCtx.getInputValue("implType");
        String descriptorType = (String)handlerCtx.getInputValue("descriptorType");
        String descriptor = null;
        
        if (implType.equals("SERVLET")) {
            if (descriptorType.equals("j2ee")) {
                descriptor = "web.xml";
            } else {
                descriptor = "sun-web.xml";
            }
        } else {
            if (descriptorType.equals("j2ee")) {
                descriptor = "ejb-jar.xml";
            } else {
                descriptor = "sun-ejb-jar.xml";
            }
        }
	
	String[] descriptors = null;
        String location = null;
	
        //load subcomponent descriptors for ear file
        if(isStandAlone.equals("false")) {
            String[] modules = (String[])MBeanUtil.invoke(
                            "com.sun.appserv:type=applications,category=config",
                            "getModuleComponents",
                            new Object[]{appName},
                            new String[]{"java.lang.String"});
            if(modules != null) {
                for (int i=0; i < modules.length; i++) {
                    try {
                        String subComponentName = new ObjectName(modules[i]).getKeyProperty("name");
                        
                        if (subComponentName.equals(moduleName)) {
                            descriptors = getDescriptors(appName, subComponentName);
                            
                            for(int j=0; descriptors != null && j < descriptors.length; j++) {
                                int index = descriptors[j].lastIndexOf(File.separator) +1;
                                String name = descriptors[j].substring(index);
                                if (name.equals(descriptor)) {
                                    location = descriptors[j];
                                    break;
                                }
                            }
                            break;
                        }
                    } catch (javax.management.MalformedObjectNameException e){
                        e.printStackTrace();
                    }
                }
            }
        } else {
            descriptors = getDescriptors(appName, null);
            for(int j=0; descriptors != null && j < descriptors.length; j++) {
                int index = descriptors[j].lastIndexOf(File.separator) +1;
                String name = descriptors[j].substring(index);
                if (name.equals(descriptor)) {
                    location = descriptors[j];
                    break;
                }
            }
        }
        handlerCtx.setOutputValue("location", location);
    }
    
    private String[] getDescriptors(String appName, String subComponent) {
	String[] descriptors = (String[])MBeanUtil.invoke(
                            "com.sun.appserv:type=applications,category=config",
                            "getDeploymentDescriptorLocations",
                            new Object[]{appName, subComponent},
                            new String[]{"java.lang.String",
                            "java.lang.String"});
	return descriptors;
    }

    public void getWsEndpointObjectName(RequestContext ctx, HandlerContext handlerCtx) {
        String key = (String)handlerCtx.getInputValue("webServiceKeyName");
        ObjectName webServiceMgr = (ObjectName)MBeanUtil.getAttribute(DOMAIN_ROOT_OBJ_NAME, WS_MGR_ATTR_NAME);
        Object[] paramsArray = {key};
        String[] typesArray  = {"java.lang.Object"};
        Map wsiMap = (Map)MBeanUtil.invoke(webServiceMgr, GETWSNAMES_METHOD, paramsArray , typesArray); 
        Boolean isStandAlone = (Boolean)wsiMap.get(IS_STANDALONE);
        String appName = (String)wsiMap.get(APP_NAME);
        String implType = (String)wsiMap.get(TYPE);
        String type = "";
        if (isStandAlone.booleanValue()) {
            if (implType.equals(SERVLET_TYPE)) {
                type = WEB_MODULE;
            } else {
                type = EJB_MODULE;
            }
        } else {
            type = J2EE_APPLICATION;
        }
        String name = key.substring(key.indexOf('#') + 1);
        String wsEndpointObjName = "com.sun.appserv:type=web-service-endpoint,name="
                                    +name+","+type+"="+appName+",category=config";
        handlerCtx.setOutputValue("wsEndpointObjectName", wsEndpointObjName);
        
        //create web-service-endpoint element if it doesn't exist
        if (!MBeanUtil.isValidMBean(wsEndpointObjName)) {
            AttributeList list = new AttributeList();
            list.add(new Attribute("jbi-enabled", "true"));
            list.add(new Attribute("max-history-size", "25"));
            list.add(new Attribute("monitoring", "OFF"));
            list.add(new Attribute("name", name));
            Object[] params = {list};
            String[] signature  = {"javax.management.AttributeList"};
            String objName = "com.sun.appserv:type="+type+",name="+appName+",category=config";
            MBeanUtil.invoke(objName, "createWebServiceEndpoint", params, signature);
        }
    }
    
    public void getServerList(RequestContext ctx, HandlerContext handlerCtx) {   
	Set wsEndpointSet = (Set) handlerCtx.getInputValue("wsEndpointSet");
        ArrayList serverRootList = new ArrayList();
        Iterator it = wsEndpointSet.iterator();
        while (it.hasNext()){
            ObjectName wsEndpoint =  (ObjectName) it.next();
            ObjectName wsMonitor = (ObjectName) MBeanUtil.getAttribute(wsEndpoint, "MonitoringPeerObjectName");
            if (wsMonitor != null){
                String serverRoot = wsMonitor.getKeyProperty("X-ServerRootMonitor");                
                serverRootList.add(serverRoot);
            }
        }
        String[] servers =  (String[])(serverRootList.toArray(new String[serverRootList.size()]));
        handlerCtx.setOutputValue("serverList", servers);
    }
    
    public void getWsMonitorsList(RequestContext ctx, HandlerContext handlerCtx) {
        
	Set wsEndpointSet = (Set) handlerCtx.getInputValue("wsEndpointSet");
        String selectedServer = (String) handlerCtx.getInputValue("selectedServer");
        ArrayList wsMonitorsList = new ArrayList();
        ArrayList serverRootList = new ArrayList();
        Iterator it = wsEndpointSet.iterator();
        while (it.hasNext()){
            ObjectName wsEndpoint =  (ObjectName) it.next();
            ObjectName wsMonitor = (ObjectName) MBeanUtil.getAttribute(wsEndpoint, "MonitoringPeerObjectName");
            if (wsMonitor != null){
                String serverRoot = wsMonitor.getKeyProperty("X-ServerRootMonitor");
                wsMonitorsList.add(wsMonitor);
                serverRootList.add(serverRoot);
            }
        }
        
        if (wsMonitorsList.size() != 0){
            handlerCtx.setOutputValue("displayServer", (selectedServer==null) ? (String) serverRootList.get(0) : selectedServer);
        }
        handlerCtx.setOutputValue("wsMonitorsList", wsMonitorsList);
        String[] test =  (String[])(serverRootList.toArray(new String[serverRootList.size()]));
        handlerCtx.setOutputValue("serverRoot", test);
        handlerCtx.setOutputValue("hasMonitors", wsMonitorsList.size()==0 ? new Boolean("false") : new Boolean("true"));
        
    }
    

public void loadWsStatisticsTable(RequestContext ctx, HandlerContext handlerCtx) {
    
	View view = handlerCtx.getView();
        ViewDescriptor desc = null;
        if (handlerCtx.getEvent() instanceof BeforeCreateEvent) {
            desc = ((BeforeCreateEvent)handlerCtx.getEvent()).getViewDescriptor();
	} else {
            DescriptorContainerView descView = (DescriptorContainerView)
                (((ViewBase)view).getParentViewBean());
            desc = descView.getViewDescriptor();
        }
        String bundle = "com.sun.enterprise.tools.admingui.resources.Resources";
        List wsMonitorsList = (List)handlerCtx.getInputValue("wsMonitorsList");
        String filter = (String) handlerCtx.getInputValue("filterValue");
        
        if (wsMonitorsList.size() == 0){
            return;
        }
        
        //filter out the preferred instance.  If none is specified, just use DAS
        
        if (Util.isEmpty(filter)){
            filter = "server";
        }
        ObjectName wsMonitor = null;
        for(int i=0; i<wsMonitorsList.size(); i++){
            wsMonitor = (ObjectName) wsMonitorsList.get(i);
            String nm = wsMonitor.getKeyProperty("X-ServerRootMonitor");
            if (nm.equals(filter)){
                break;
            }
        }
        if (wsMonitor == null) {
            //can't find the one specified, Just use the first one.
            wsMonitor = (ObjectName) wsMonitorsList.get(0);
        }
        
        try {
            CCActionTableModelInterface model = (CCActionTableModelInterface)handlerCtx.getInputValue("model");
            if (model == null) {
                throw new FrameworkException("WebSErviceHandler.loadWsStatisticsTable: No Model Specified.", desc, view);
            }
            ((DefaultModel)model).clear();
            model.beforeFirst();
           
            //Avg Response time
            model.appendRow();
            model.setValue("statistic", Util.getMessage("webServiceMonitorStatistics.lastRespTime"));
            String[] lastR = { ""+MBeanUtil.getAttribute(wsMonitor, "ResponseTime_Count")};
            model.setValue("value", Util.getMessage("webServiceMonitorStatistics.ms", lastR ));
            
            model.appendRow();
            model.setValue("statistic", Util.getMessage("webServiceMonitorStatistics.avgRespTime"));
            String[] tt = { ""+MBeanUtil.getAttribute(wsMonitor, "AverageResponseTime_Count")};
            model.setValue("value", Util.getMessage("webServiceMonitorStatistics.ms", tt ));
            
            model.appendRow();
            model.setValue("statistic", Util.getMessage("webServiceMonitorStatistics.minRespTime"));
            String[] min = { ""+MBeanUtil.getAttribute(wsMonitor, "MinResponseTime_Count")};
            model.setValue("value", Util.getMessage("webServiceMonitorStatistics.ms", min ));
            
            model.appendRow();
            model.setValue("statistic", Util.getMessage("webServiceMonitorStatistics.maxRespTime"));
            String[] max = { ""+MBeanUtil.getAttribute(wsMonitor, "MaxResponseTime_Count")};
            model.setValue("value", Util.getMessage("webServiceMonitorStatistics.ms", max ));
            
            model.appendRow();
            model.setValue("statistic", Util.getMessage("webServiceMonitorStatistics.Throughput"));
            
            Double dd = (Double) MBeanUtil.getAttribute(wsMonitor,"Throughput_Current");
            NumberFormat numberformat = NumberFormat.getInstance();
            numberformat.setMinimumFractionDigits(2);
            String [] put = {numberformat.format(dd.doubleValue())};
            model.setValue("value", Util.getMessage("webServiceMonitorStatistics.reqPerSec", put ));
            
            /* commented out for now till backend can give the correct data.
            model.appendRow();
            model.setValue("statistic", Util.getMessage("webServiceMonitorStatistics.AuthSuccess"));
            model.setValue("value", ""+MBeanUtil.getAttribute(wsMonitor, "TotalAuthSuccesses_Count"));
            
            model.appendRow();
            model.setValue("statistic", Util.getMessage("webServiceMonitorStatistics.AuthFailure"));
            model.setValue("value", ""+MBeanUtil.getAttribute(wsMonitor, "TotalAuthFailures_Count"));
            
             */
            model.appendRow();
            model.setValue("statistic", Util.getMessage("webServiceMonitorStatistics.Faults"));
            model.setValue("value", ""+MBeanUtil.getAttribute(wsMonitor, "TotalFaults_Count"));
            
            model.appendRow();
            model.setValue("statistic", Util.getMessage("webServiceMonitorStatistics.totalSuccess"));
            model.setValue("value", ""+MBeanUtil.getAttribute(wsMonitor, "TotalNumSuccess_Count"));
            
            
        } catch (Exception ex) {
            throw new FrameworkException("loadWsStatisticsTable: Loading error. ", ex, desc, view);
        }
    }

    public void wsResetData(RequestContext ctx, HandlerContext handlerCtx) {
        
	String webServiceKey = (String) handlerCtx.getInputValue("webServiceKey");
        String serverName = (String) handlerCtx.getInputValue("serverName");
        ObjectName wsEndpoint = getWsEndpoint(webServiceKey, serverName);
        
        //If we invoke the method, there will be mbean exception without any stack trace or cause.
        //we have to use dynamic proxies to get this to work.
        
        /*
        if (wsEndpoint != null){
            MBeanUtil.invoke(wsEndpoint, RESET_STATS_METHOD, null, null);
        }
         */
        
        WebServiceMgr wsm = AMXUtil.getAMXProxyFactory().getDomainRoot().getWebServiceMgr();
        Set endpointSet = wsm.getWebServiceEndpointSet((Object)webServiceKey, serverName);
        if (!endpointSet.isEmpty()){  // should be only one.
            Iterator it = endpointSet.iterator();
            WebServiceEndpoint endpoint = (WebServiceEndpoint) it.next();
            endpoint.resetStats();
        }
    }
    
    public void getWsLastResetTime(RequestContext ctx, HandlerContext handlerCtx) {
	String webServiceKey = (String) handlerCtx.getInputValue("webServiceKey");
        String serverName = (String) handlerCtx.getInputValue("serverName");
        ObjectName wsEndpoint = (ObjectName) getWsEndpoint(webServiceKey, serverName);
        if (wsEndpoint != null){
            Long lastResetTime = (Long) MBeanUtil.getAttribute(wsEndpoint, "LastResetTime");
            handlerCtx.setOutputValue("time", lastResetTime.toString());
        }else
            handlerCtx.setOutputValue("time", "");
    }
    
     public void removeWsRTGraphFromSession(RequestContext ctx, HandlerContext handlerCtx) {
	String suffix = (String) handlerCtx.getInputValue("suffix");
//        System.out.println ("!!!!!!!!! suffix = " + suffix);
        HttpSession session = ctx.getRequest().getSession();
        session.removeAttribute("wsResponseTimeRTChart" + suffix);
        session.removeAttribute("wsThroughputRTChart" + suffix);
        session.removeAttribute("wsAuthRTChart" + suffix);
        session.removeAttribute("wsCountRTChart" + suffix);
    }
    
            
    public void loadPublishTableModel(RequestContext ctx, HandlerContext handlerCtx) {
        CCActionTableModelInterface model = (CCActionTableModelInterface)handlerCtx.getInputValue("tableModel");
        ((DefaultModel)model).clear();
        String webServiceKey = (String)handlerCtx.getInputValue("webServiceKey");
        String registryCol = (String)handlerCtx.getInputValue("registryCol");
        Map registryMap = getRegistryLocationConfigMap(webServiceKey);
        if (registryMap != null && !registryMap.isEmpty()) {
            for (Iterator iter = registryMap.values().iterator(); iter.hasNext();) {
                RegistryLocationConfig registry = (RegistryLocationConfig)iter.next();
                model.appendRow();
                model.setValue(registryCol, registry.getConnectorResourceJNDIName());
            }
        }
    }
    
    
    public void processWebServiceKeyName(RequestContext ctx, HandlerContext handlerCtx) {
	String webServiceKey = (String) handlerCtx.getInputValue("key");
        String replaceWith = (String) handlerCtx.getInputValue("replaceWith");
        String converted = webServiceKey.replaceAll("@", replaceWith);
        handlerCtx.setOutputValue("converted", converted);
    }
    
    
    
    public void publishToRegistry(RequestContext ctx, HandlerContext handlerCtx) {
        Object webServiceKey = (Object)handlerCtx.getInputValue("webServiceKey");
        String childName = (String)handlerCtx.getInputValue("addRemoveChildName");
        
        View view = handlerCtx.getView();
	DescriptorContainerView descView = (DescriptorContainerView)
	    (((ViewBase)view).getParentViewBean());
        
	ViewDescriptor vd = descView.getViewDescriptor();
        ViewDescriptor propSheet = vd.getChildDescriptor("webServicePublishToRegistry");
        ViewDescriptor desc = propSheet.getChildDescriptor(childName);
        
        CCAddRemoveDescriptor addRemoveDesc = ((CCAddRemoveDescriptor)desc);
        CCAddRemove addRemoveChild = (CCAddRemove)addRemoveDesc.getView(ctx);
        CCAddRemoveModelInterface model = addRemoveDesc.getModel();
        OptionList selectedOptions = model.getSelectedOptionList(addRemoveChild);
        if (selectedOptions ==  null) { 
            selectedOptions = model.getSelectedOptionList();
        }
        String[] registries = null;
        if (selectedOptions != null) {
            registries = new String[selectedOptions.size()];
            for (int i = 0; i < registries.length; i++) {
                registries[i] = selectedOptions.getValue(i);
            }
        }
        
        if (registries !=  null && registries.length > 0) {
            String lbhost = (String)handlerCtx.getInputValue("lbhost");
            String lbport = (String)handlerCtx.getInputValue("lbport");
            String lbsslport = (String)handlerCtx.getInputValue("lbsslport");
            String categories = (String)handlerCtx.getInputValue("categories");
            String description = (String)handlerCtx.getInputValue("description");
            String organization = (String)handlerCtx.getInputValue("organization");
            HashMap map = new HashMap();
            map.put(WebServiceMgr.LB_HOST_KEY, lbhost);
            map.put(WebServiceMgr.LB_PORT_KEY, lbport);
            map.put(WebServiceMgr.LB_SECURE_PORT, lbsslport);
            map.put(WebServiceMgr.CATEGORIES_KEY, categories);
            map.put(WebServiceMgr.DESCRIPTION_KEY, description);
            map.put(WebServiceMgr.ORGANIZATION_KEY, organization);
            WebServiceMgr wsm = (WebServiceMgr)AMXUtil.getDomainRoot().getWebServiceMgr();
            wsm.publishToRegistry(registries, webServiceKey, map);
        }
    }
    
    public void unpublishFromRegistry(RequestContext ctx, HandlerContext handlerCtx) {
        CCActionTableModelInterface model = (CCActionTableModelInterface)handlerCtx.getInputValue("tableModel");
        Object webServiceKey = (Object)handlerCtx.getInputValue("webServiceKey");
        String registryCol = (String)handlerCtx.getInputValue("registryCol");   
        String[] registries = null;
        try {
            registries = getSelectedRows(registryCol, model);
        } catch (com.iplanet.jato.model.ModelControlException mce) {
            ViewDescriptor vd = handlerCtx.getViewDescriptor();
            String childName = (String)vd.getParameter("tableChildName");
            ViewDescriptor tableDescriptor = vd.getChildDescriptor(childName);
            throw new FrameworkException("Error while unpublishing: '"+
		webServiceKey.toString()+"from " + model.getValue(registryCol).toString()+ "'", mce, tableDescriptor, null);
        }
        WebServiceMgr wsm = (WebServiceMgr)AMXUtil.getDomainRoot().getWebServiceMgr();
        wsm.unpublishFromRegistry(registries, webServiceKey);
    }
    
    public void setAddRemoveAvailableRegistriesList(RequestContext ctx, HandlerContext handlerCtx) {
        ViewDescriptor vd = vd = handlerCtx.getViewDescriptor();
        WebServiceMgr wsm = (WebServiceMgr)AMXUtil.getDomainRoot().getWebServiceMgr();
        String[] registries = wsm.listRegistryLocations();
        if (registries != null && registries.length > 0) {

            CCAddRemoveDescriptor addRemoveDesc = (CCAddRemoveDescriptor)vd;
            CCAddRemoveModelInterface model = addRemoveDesc.getModel();
            model.setAvailableOptionList(new OptionList(registries, registries));
        }
    }
    
    public void loadRegistriesTableModel(RequestContext ctx, HandlerContext handlerCtx) {
        CCActionTableModelInterface model = (CCActionTableModelInterface)handlerCtx.getInputValue("tableModel");
        ((DefaultModel)model).clear();
        WebServiceMgr wsm = (WebServiceMgr)AMXUtil.getDomainRoot().getWebServiceMgr();
        
        String[] registries = wsm.listRegistryLocations();
        if (registries != null) {
            for (int i=0; i < registries.length; i++) {
                model.appendRow();
                model.setValue("registryName",  registries[i]);
            }
        }
    }
    
    public void addRegistry(RequestContext ctx, HandlerContext handlerCtx) {
        String jndiName = (String)handlerCtx.getInputValue("jndiName");
        String registryType = (String)handlerCtx.getInputValue("registryType");
        String publishURL = (String)handlerCtx.getInputValue("publishURL");
        String queryURL = (String)handlerCtx.getInputValue("queryURL");
        String userName = (String)handlerCtx.getInputValue("userName");
        String password = (String)handlerCtx.getInputValue("password");
        String description = (String)handlerCtx.getInputValue("description");
        Map map = new HashMap();
	String type = WebServiceMgr.EBXML_KEY;
	if (registryType.equalsIgnoreCase (WebServiceMgr.UDDI_KEY)){
		type = WebServiceMgr.UDDI_KEY;
	} else {
		type = WebServiceMgr.EBXML_KEY;
	} 
        map.put(WebServiceMgr.PUBLISH_URL_KEY,  publishURL);
        if (!Util.isEmpty(queryURL)) {
            map.put(WebServiceMgr.QUERY_URL_KEY, queryURL);
        }
        if (!Util.isEmpty(userName)) {
            map.put(WebServiceMgr.USERNAME_KEY, userName);
        }
        if (!Util.isEmpty(password)) {
            map.put(WebServiceMgr.PASSWORD_KEY, password);
        }
        WebServiceMgr wsm = (WebServiceMgr)AMXUtil.getDomainRoot().getWebServiceMgr();
        wsm.addRegistryConnectionResources(jndiName, description, type, map);
    }
    
    public void removeSelectedRegistries(RequestContext ctx, HandlerContext handlerCtx) throws ModelControlException {
        CCActionTableModelInterface model = (CCActionTableModelInterface)handlerCtx.getInputValue("tableModel");
        String[] selectedRegistries = getSelectedRows("registryName", model);
        WebServiceMgr wsm = (WebServiceMgr)AMXUtil.getDomainRoot().getWebServiceMgr();
        for (int i=0;i < selectedRegistries.length; i++) {
            wsm.removeRegistryConnectionResources(selectedRegistries[i]); //TODO Pass String[] instead of String
        }
    }
    
    public void loadTransformationRulesTableModel(RequestContext ctx, HandlerContext handlerCtx) {
        String webServiceKey = (String)handlerCtx.getInputValue("webServiceKey");
        CCActionTableModelInterface model = (CCActionTableModelInterface)handlerCtx.getInputValue("tableModel");
        ((DefaultModel)model).clear();
        List ruleList = getTransformationRuleConfigList(webServiceKey);
        if (ruleList != null && !ruleList.isEmpty()) {
            for (Iterator iter = ruleList.iterator(); iter.hasNext();) {
                TransformationRuleConfig rule = (TransformationRuleConfig)iter.next();
                model.appendRow();
                model.setValue("ruleName", rule.getName());
                if (rule.getEnabled()) {
                    model.setValue("ruleStatus", Util.getMessage("common.Enabled"));
                } else {
                    model.setValue("ruleStatus", Util.getMessage("common.Disabled"));
                }
                model.setValue("ruleFile", rule.getRuleFileLocation());
                model.setValue("applyTo", rule.getApplyTo());       
            }
        }
    }
    
    public void applyTransformationRulesTableAction(RequestContext ctx, HandlerContext handlerCtx) {
        String webServiceKey = (String)handlerCtx.getInputValue("webServiceKey");
        String ruleNameCol = (String)handlerCtx.getInputValue("ruleNameCol");
        String action = (String)handlerCtx.getInputValue("action");
        CCActionTableModelInterface model = (CCActionTableModelInterface)handlerCtx.getInputValue("tableModel");
        String[] rules = null; 
        try {
            rules = getSelectedRows(ruleNameCol, model);
        } catch (com.iplanet.jato.model.ModelControlException mce) {
            ViewDescriptor vd = handlerCtx.getViewDescriptor();
            String childName = (String)vd.getParameter("tableChildName");
            ViewDescriptor tableDescriptor = vd.getChildDescriptor(childName);
            throw new FrameworkException("Error while getting selected transformation rules: '"+
		model.getValue(ruleNameCol).toString()+ "'", mce, tableDescriptor, null);
        }
        WebServiceEndpointConfig endpointConfig = getWebServiceEndpointConfig(webServiceKey);
        if (endpointConfig != null) {
            Map ruleMap = endpointConfig.getTransformationRuleConfigMap();
            if (action.equals("enable")) {
                for (int i=0; i < rules.length; i++) {
                    TransformationRuleConfig rule = (TransformationRuleConfig)ruleMap.get(rules[i]);
                    rule.setEnabled(true);
                }
            } else if (action.equals("disable")) {
                for (int i=0; i < rules.length; i++) {
                    TransformationRuleConfig rule = (TransformationRuleConfig)ruleMap.get(rules[i]);
                    rule.setEnabled(false);
                }
            } else if (action.equals("remove")) {
                for (int i=0; i < rules.length; i++) {
                    endpointConfig.removeTransformationRuleConfig(rules[i]);
                }
            }
        }
    }
    
    private String[] getSelectedRows(String col, CCActionTableModelInterface model)
            throws com.iplanet.jato.model.ModelControlException {
        ArrayList arrList = new ArrayList();
        model.setSelectionType("multiple");
        model.beforeFirst();
        while(model.next()) {
            if (model.isRowSelected()) {
                arrList.add(model.getValue(col).toString());
            }
        }
        return (String[])arrList.toArray(new String[arrList.size()]);
    }
    
    public void getWebServiceDisplayName(RequestContext ctx, HandlerContext handlerCtx) {
        Object webServiceKey = (Object)handlerCtx.getInputValue("webServiceKey");
        WebServiceMgr wsm = (WebServiceMgr)AMXUtil.getDomainRoot().getWebServiceMgr();
        String name = (String)wsm.getWebServiceEndpointKeys().get(webServiceKey);
        handlerCtx.setOutputValue("webServiceName", name);
    }
    
    public void isStandAlone(RequestContext ctx, HandlerContext handlerCtx) {
        Object webServiceKey = (Object)handlerCtx.getInputValue("webServiceKey");
        WebServiceMgr wsm = (WebServiceMgr)AMXUtil.getDomainRoot().getWebServiceMgr();
        final WebServiceEndpointInfo wsi = wsm.getWebServiceEndpointInfo(webServiceKey);
        handlerCtx.setOutputValue("isStandAlone", "" + wsi.isAppStandaloneModule() );
    }
    
    public void getAppID(RequestContext ctx, HandlerContext handlerCtx) {
        Object webServiceKey = (Object)handlerCtx.getInputValue("webServiceKey");
        WebServiceMgr wsm = (WebServiceMgr)AMXUtil.getDomainRoot().getWebServiceMgr();
        final WebServiceEndpointInfo info = wsm.getWebServiceEndpointInfo(webServiceKey);
        handlerCtx.setOutputValue("appID", "" + info.getAppID());
    }
    
    public void isSecure(RequestContext ctx, HandlerContext handlerCtx) {
        Object webServiceKey = (Object)handlerCtx.getInputValue("webServiceKey");
        WebServiceMgr wsm = (WebServiceMgr)AMXUtil.getDomainRoot().getWebServiceMgr();
        final WebServiceEndpointInfo info = wsm.getWebServiceEndpointInfo(webServiceKey);
        handlerCtx.setOutputValue("isSecure", info.isSecure());
    }
    
    public void getFileContent(RequestContext ctx, HandlerContext handlerCtx) {
        Object webServiceKey = (Object)handlerCtx.getInputValue("webServiceKey");
        
        final String fileKey = (String)handlerCtx.getInputValue("fileKey");
        
        final WebServiceMgr wsm = AMXUtil.getDomainRoot().getWebServiceMgr();
        final WebServiceEndpointInfo info = wsm.getWebServiceEndpointInfo(webServiceKey);
        
        final Map<String,java.io.Serializable> wsiMap    = info.asMap();
        
        String content = (String)wsiMap.get(fileKey);
        String type = info.getServiceImplType();
        if (fileKey.equals("j2eeDescriptorFile")) {
            if (type.equals("SERVLET")) {
                content = info.getWebXML();
            } else {
                content = info.getEJBXML();
            }
        } else if (fileKey.equals("sunDescriptorFile")) {
            if (type.equals("SERVLET")) {
                content = info.getSunWebXML();
            } else {
                content = info.getSunEJBXML();
            }
        }
        handlerCtx.setOutputValue("fileContent", content);
    }
    
    private ObjectName getWsEndpoint(String webServiceKey, String serverName){
        Object[] params = {webServiceKey, serverName};
        String[] types={"java.lang.Object", "java.lang.String"};
        Set endpointSet = (Set) MBeanUtil.invoke(WS_MGR_OBJ_NAME, GETWSENDPOINTSET_METHOD,  params, types );
        Iterator it = endpointSet.iterator();
        return (endpointSet.isEmpty() ? null : (ObjectName)it.next());
        
    }
    
    private static Map getWebServiceEndpointInfoMap(String key) {
        ObjectName webServiceMgr = (ObjectName)MBeanUtil.getAttribute(DOMAIN_ROOT_OBJ_NAME, WS_MGR_ATTR_NAME);        
        Object[] paramsArray = {key};
        String[] typesArray  = {"java.lang.Object"};
        Map wsiMap = (Map)MBeanUtil.invoke(webServiceMgr, GETWSNAMES_METHOD, paramsArray , typesArray);     
        return wsiMap;
    }

    private static Object getWebServiceAttribute(String key, String attribute) {
        ObjectName webServiceMgr = (ObjectName)MBeanUtil.getAttribute(DOMAIN_ROOT_OBJ_NAME, WS_MGR_ATTR_NAME);        
        Object[] paramsArray = {key};
        String[] typesArray  = {"java.lang.Object"};
        Map wsiMap = (Map)MBeanUtil.invoke(webServiceMgr, GETWSNAMES_METHOD, paramsArray , typesArray);     
        return wsiMap.get(attribute);
    }
    
    private static RegistryLocationConfig getRegistryLocationConfig(String webServiceKey, String registryName) {
        return (RegistryLocationConfig)getRegistryLocationConfigMap(webServiceKey).get(registryName);
    }
    
    private static Map getRegistryLocationConfigMap(String webServiceKey) {
        WebServiceEndpointConfig wseConfig = getWebServiceEndpointConfig(webServiceKey);
        return wseConfig == null ? null : wseConfig.getRegistryLocationConfigMap();
    }
    
    public static TransformationRuleConfig createTransformationRuleConfig(String webServiceKey, String ruleName, boolean enabled, String applyTo, String ruleFileLocation, Map map) {
        WebServiceEndpointConfig wseConfig = getWebServiceEndpointConfig(webServiceKey);
	if (wseConfig == null) {
            wseConfig = createWebServiceEndpointConfig(webServiceKey);
        }
        
        return wseConfig.createTransformationRuleConfig(ruleName, ruleFileLocation, enabled, applyTo, map);
    }
    
    private static TransformationRuleConfig getTransformationRuleConfig(String webServiceKey, String ruleKey) {
        return (TransformationRuleConfig)getTransformationRuleConfigMap(webServiceKey).get(ruleKey);
    }
    
    private static Map getTransformationRuleConfigMap(String webServiceKey) {
        WebServiceEndpointConfig wseConfig = getWebServiceEndpointConfig(webServiceKey);
        return wseConfig == null ? null : wseConfig.getTransformationRuleConfigMap();
    }
    
    private static List getTransformationRuleConfigList(String webServiceKey) {
        WebServiceEndpointConfig wseConfig = getWebServiceEndpointConfig(webServiceKey);
        return wseConfig == null ? null : wseConfig.getTransformationRuleConfigList();
    }
    
    private static WebServiceEndpointConfig createWebServiceEndpointConfig(String webServiceKey) {
        Map m = getAMXWebServiceInfo(webServiceKey);
        String appJ2EEType = (String)m.get(J2EE_TYPE);
        String appName = (String)m.get(APPL_NAME);
        String name = (String)m.get(WS_NAME);
        String appConfigObjName =
            AMX.JMX_DOMAIN    + ":" +
            AMX.J2EE_TYPE_KEY + "=" + appJ2EEType + "," +
            AMX.NAME_KEY      + "=" + appName;
        Set appConfigSet = null;
        QueryMgr queryMgr = AMXUtil.getQueryMgr();
        try {
            appConfigSet = queryMgr.queryPatternSet(new ObjectName(appConfigObjName));
        } catch (javax.management.MalformedObjectNameException e) {
            e.printStackTrace();
        }
        if (appConfigSet.size() > 1) {
            throw new RuntimeException("More than 1 MBean returned from QueryMgr.queryPatternSet("+appConfigObjName+")");
        }
        if (appConfigSet.size() == 0) {
            throw new RuntimeException("No MBean returned from QueryMgr.queryPatternSet("+appConfigObjName+") for application " + appName);
        }
        Iterator it = appConfigSet.iterator();
        Object config = null;
        if (it.hasNext()) {
            config = it.next();
        }
        WebServiceEndpointConfig wec = null;
        if (config instanceof J2EEApplicationConfig) {
            wec = ((J2EEApplicationConfig)config).createWebServiceEndpointConfig(name, null);
        } else if (config instanceof WebModuleConfig) {
            wec = ((WebModuleConfig)config).createWebServiceEndpointConfig(name, null);
        } else if (config instanceof EJBModuleConfig) {
            wec = ((EJBModuleConfig)config).createWebServiceEndpointConfig(name, null);
        }
        return wec;
    }
    
    private static WebServiceEndpointConfig getWebServiceEndpointConfig(String webServiceKey) {
        Map m = getAMXWebServiceInfo(webServiceKey);
        String appJ2EEType = (String)m.get(J2EE_TYPE);
        String appName = (String)m.get(APPL_NAME);
        String name = (String)m.get(WS_NAME);
        String wsEndpointConfigObjName =  
                AMX.JMX_DOMAIN    + ":" +
                appJ2EEType       + "=" + appName + "," +
                AMX.J2EE_TYPE_KEY + "=" + WebServiceEndpointConfig.J2EE_TYPE + "," +
                AMX.NAME_KEY      + "=" + name;
        QueryMgr queryMgr = AMXUtil.getQueryMgr();
        Set amxSet = null;
        try {
            amxSet = queryMgr.queryPatternSet(new ObjectName(wsEndpointConfigObjName));
        } catch (javax.management.MalformedObjectNameException e) {
            e.printStackTrace();
        }
        if (amxSet.size() > 1) {
            throw new RuntimeException("More than 1 MBean returned from QueryMgr.queryPatternSet("+wsEndpointConfigObjName+")");
        }
        Iterator it = amxSet.iterator();
        WebServiceEndpointConfig wec = null;
        if (it.hasNext()) {
            wec = (WebServiceEndpointConfig)it.next();
        }
        return wec;
    }
    
    private static Map getAMXWebServiceInfo(String webServiceKey) {
        Map m = getWebServiceEndpointInfoMap(webServiceKey);
        Boolean isStandAlone = (Boolean)m.get(WebServiceEndpointInfo.IS_STAND_ALONE_MODULE_KEY);
        String implType = (String)m.get(WebServiceEndpointInfo.SERVICE_IMPL_TYPE_KEY);
        String appName = (String)m.get(WebServiceEndpointInfo.APP_ID_KEY);
        String name = (String)webServiceKey.substring(webServiceKey.indexOf('#') + 1);
        String appJ2EEType = null;
        if (isStandAlone.booleanValue()) {
            if (implType.equals(WebServiceEndpointInfo.SERVLET_IMPL)) {
                appJ2EEType = WebModuleConfig.J2EE_TYPE;
            } else if (implType.equals(WebServiceEndpointInfo.EJB_IMPL)) {
                appJ2EEType = EJBModuleConfig.J2EE_TYPE;
            }
        } else {
            appJ2EEType = J2EEApplicationConfig.J2EE_TYPE;
        }
        Map map = new HashMap();
        map.put(APPL_NAME, appName);
        map.put(WS_NAME, name);
        map.put(J2EE_TYPE, appJ2EEType);
        return map;
    }
    
    public static final String DOMAIN_ROOT_OBJ_NAME = "amx:j2eeType=X-DomainRoot,name=amx";
    public static final String WS_MGR_ATTR_NAME = "WebServiceMgrObjectName";
    public static final String WS_MGR_OBJ_NAME = "amx:j2eeType=X-WebServiceMgr,name=na";
    public static final String GETWSNAMES_METHOD = "getWebServiceEndpointInfo";
    public static final String WSNAMESMAP_ATTR_NAME = "WebServiceEndpointKeys";
    public static final String GETWSENDPOINTSET_METHOD = "getWebServiceEndpointObjectNameSet";
    public static final String RESET_STATS_METHOD = "resetStats";
    
    public static final String APP_CONFIG_OBJ_NAME = "com.sun.appserv:type=applications,category=config";
    public static final String IS_STANDALONE = "IsAppStandAloneModule";
    public static final String TYPE = "ServiceImplType";
    public static final String APP_NAME = "AppID";
    public static final String SERVLET_TYPE = "SERVLET";
    public static final String J2EE_APPLICATION = "j2ee-application";
    public static final String WEB_MODULE = "web-module";
    public static final String EJB_MODULE = "ejb-module";
    
    private static final String J2EE_TYPE = "j2eeType";
    private static final String APPL_NAME = "appName";
    private static final String WS_NAME = "wsName";
}
