/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * WizardHandlers.java
 *
 * Created on October 6, 2003, 10:10 AM
 */

package com.sun.enterprise.tools.admingui.handlers;

import com.iplanet.jato.ModelManager;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestContextImpl;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.Model;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;

import com.sun.enterprise.tools.admingui.util.MBeanUtil;
import com.sun.enterprise.tools.admingui.util.Util;

import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.DescriptorCCPageTitle;
import com.sun.enterprise.tools.guiframework.view.DescriptorContainerView;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.enterprise.tools.guiframework.view.ViewDescriptorManager;
import com.sun.enterprise.tools.guiframework.view.descriptors.CCActionTableDescriptor;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;

import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.model.CCPropertySheetModelInterface;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;

import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.AttributeList;
import javax.management.Attribute;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;


/**
 *
 */
public class WizardHandlers {

    /**
     *
     */
    public void create(RequestContext ctx, HandlerContext handlerCtx) {
        DescriptorContainerView descView = (DescriptorContainerView)ctx.getRequest().getAttribute("wizardView");
        ArrayList displayNames = (ArrayList)ctx.getRequest().getAttribute("displayNames");
        ArrayList modelNames = (ArrayList)ctx.getRequest().getAttribute("modelNames");
        String objectName = (String)ctx.getRequest().getAttribute("objectName");
        String methodName = (String)ctx.getRequest().getAttribute("methodName");
        AttributeList attrList = new AttributeList();

        for (int i = 0; i < displayNames.size(); i++) {
            Attribute attr = new Attribute((String)modelNames.get(i),
                (String)descView.getDisplayFieldValue(((String)(displayNames.get(i)))));
            attrList.add(attr);
        }

        Object params[] = {attrList};
        String types[] = {"javax.management.AttributeList"};
        try {
        Object obj = MBeanUtil.invoke(objectName, methodName, params, types);
        ObjectName objName = (ObjectName)obj;
	if (Util.isLoggableFINEST()) {
	    Util.logFINEST("In create object name is: "+objName.toString());
	}
        ctx.getRequest().setAttribute(PROPS_OBJECT_NAME, objName.toString());
        } catch (Exception ex) {
            throw new FrameworkException(
		ex, descView.getViewDescriptor(), handlerCtx.getView());
        }
    }


    /**
     *
     */
    public void saveProperties(RequestContext ctx, HandlerContext handlerCtx) throws ModelControlException {
        DescriptorContainerView descView = (DescriptorContainerView)ctx.getRequest().getAttribute("wizardView");

        CCActionTableModelInterface model =
            (CCActionTableModelInterface)ctx.getRequest().getAttribute("wizardTableModel");
        String objectName = (String)ctx.getRequest().getAttribute(PROPS_OBJECT_NAME);
	if (Util.isLoggableFINEST()) {
	    Util.logFINEST("In save object name is: "+objectName);
	}
        model.setRowSelectionType("multiple");
        model.beforeFirst();
        AttributeList attrs = new AttributeList();
        String[] type = new String[]{"javax.management.Attribute"};
        try {
            while(model.next()) {
                String name = (String) model.getValue(PROPERTY_NAME);
                String value = (String) model.getValue(PROPERTY_VALUE);
                if (name != null && (!name.trim().equals(""))) {
                    Object params[] = {new Attribute(name, value)};
                    MBeanUtil.invoke(objectName, "setProperty", params, type);
                }
            }
        } catch (Exception ex) {
            throw new FrameworkException(
		ex, descView.getViewDescriptor(), handlerCtx.getView());
        }
    }


    /**
     *
     */
    public void  isTableLoaded(RequestContext ctx, HandlerContext handlerCtx) {
        boolean tL = false;
        if (ctx.getRequest().getAttribute(TABLE_LOAD) != null){
            tL = new Boolean(""+ctx.getRequest().getAttribute(TABLE_LOAD)).booleanValue();
        }

        if(tL) {
            ctx.getRequest().setAttribute(TABLE_LOAD, "true");
        } else {
            ctx.getRequest().setAttribute(TABLE_LOAD, "false");
        }

    }


    /**
     *
     */
    public void addProperty(RequestContext ctx, HandlerContext handlerCtx) {
	ServletRequest req = ctx.getRequest();

        DescriptorContainerView descView = (DescriptorContainerView)req.getAttribute("property.child");

	if (descView == null) {
	    throw new FrameworkException(
		"addPropertyTest: 'child' attributes were null!", null, handlerCtx.getView());
	}

        CCActionTableModelInterface model = (CCActionTableModelInterface)req.getAttribute(PROP_MODEL);
	if (Util.isLoggableFINEST()) {
	    Util.logFINEST("**MODEL IS: "+model);
	}

        //model.setRowSelectionType("multiple");
	try {
	    if ((model != null) && (model instanceof DefaultModel)) {
                model.last();

		if (Util.isLoggableFINEST()) {
		    // Log some stuff...
		    StringBuffer buf = new StringBuffer();
		    buf.append("MODEL IS NOT NULL:\n");
		    buf.append("**Number of rows: "+model.getNumRows()+"***");
		    buf.append("**Last row index: "+((CCActionTableModel)model).getLastRowIndex()+"***");
		    Util.logFINEST(buf.toString());
		}

                model.appendRow();
                ((CCActionTableModel)model).sort();
                model.setValue(PROPERTY_NAME, "");
                model.setValue(PROPERTY_VALUE, "");
		if (Util.isLoggableFINEST()) {
		    Util.logFINEST("***Number of rows: "+model.getNumRows()+"***");
		}
                model.beforeFirst();
            } else {
		if (Util.isLoggableFINEST()) {
		    Util.logFINEST("MODEL IS NULL");
		}
            }
        } catch (Exception ex) {
	    throw new FrameworkException(
		ex, descView.getViewDescriptor(), handlerCtx.getView());
	}
        descView.forwardTo(ctx);
    }


    /**
     *
     */
    public void deleteProperties(RequestContext ctx, HandlerContext handlerCtx) {
    	// Get the ServletRequest
	ServletRequest req = ctx.getRequest();
        DescriptorContainerView descView = (DescriptorContainerView)req.getAttribute("property.child");

        CCActionTableModelInterface model = (CCActionTableModelInterface)req.getAttribute(PROP_MODEL);
	if (Util.isLoggableFINEST()) {
	    Util.logFINEST("Model name is: "+model);
	}
        model.setRowSelectionType("multiple");

	try {
	    model.beforeFirst();
	    AttributeList attrs = new AttributeList();

	    while(model.next()) {
		if (!model.isRowSelected()) {
		    String name = (String) model.getValue(PROPERTY_NAME);
		    String value = (String)model.getValue(PROPERTY_VALUE);
		    if (Util.isLoggableFINEST()) {
			Util.logFINEST("Property '"+name+"' with value '"+value+"' not selected.");
		    }

		    if (name != null && (! name.trim().equals(""))) {
			attrs.add(new Attribute(name, value));
		    }
		}
	    }
	    ((DefaultModel)model).clear();
	    if (attrs != null) {
		for (int props=0; props<attrs.size(); props++) {
		    Attribute attr = (Attribute)attrs.get(props);
		    Object attrValue = attr.getValue();
		    String attrName = attr.getName();
		    model.appendRow();
		    ((CCActionTableModel)model).sort();
		    model.setValue(PROPERTY_NAME, attr.getName());
		    model.setValue(PROPERTY_VALUE, attr.getValue());
		    model.setRowSelected(false);
		}
	    }
	} catch (Exception ex) {
	    throw new FrameworkException(
		ex, descView.getViewDescriptor(), handlerCtx.getView());
	}
    }


    /**
     *	This method iterates over an array of Model names.  For each model
     *	name, it clears the Model (in the case of DefaultModels) and checks
     *	to see if the model exists in Session.  If it does exist in Session,
     *	it will be removed from session.  This method expects MODEL_NAMES
     *	("modelNames") to be a request Attribute specifying the Model names
     *	to remove.
     */
    public void clearModels(RequestContext ctx, HandlerContext handlerCtx) {
    	// Get the array of Strings
	HttpServletRequest req = ctx.getRequest();
	Object obj = req.getAttribute(MODEL_NAMES);
	if (obj == null) {
	    throw new FrameworkException(
		"You must specifiy '"+MODEL_NAMES+"' to remove from Session.");
	}
	if (obj instanceof String) {
	    ArrayList list = new ArrayList();
	    list.add(obj);
	    obj = list;
	}
	if (!(obj instanceof List)) {
	    throw new FrameworkException(
		"'"+MODEL_NAMES+"' must be a java.util.List!");
	}
	String names[] =
	    (String [])((List)obj).toArray(new String[((List)obj).size()]);

	// Check and remove each model as necessary.
	HttpSession session = req.getSession();
	ModelManager modelMgr = ctx.getModelManager();
	Model model = null;
	for (int count=0; count<names.length; count++) {
	    obj = session.getAttribute(names[count]);
	    if (obj != null) {
		model = (Model)obj;
		if (model instanceof DefaultModel) {
		    // First clear() the model b/c the model on the next
		    // page will still be in memory and needs to be reset.
		    ((DefaultModel)model).clear();
		}
		modelMgr.removeFromSession(model);
	    }
	}
    }


    /**
     *	This is the attribute name that refers to the model names to delete.
     */
    public static final String	MODEL_NAMES	 = "clearModels.modelNames";
    public static final String	PROPERTY_NAME     = "propertyName";
    public static final String	PROPERTY_VALUE    = "propertyValue";
    public static final String	PROPS_OBJECT_NAME = "resourceName";
    public static final String  TABLE_LOAD        = "wizard.loadTable";
    public static final String  PROP_MODEL        = "property.model";
    public static final String  PROP_CHILD	  = "property.child";
}
