/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.admingui.util;

import java.io.*;
import java.io.IOException;
import java.util.jar.*;
import java.util.zip.ZipEntry;

import com.sun.enterprise.admin.server.core.AdminService;

/**
 * File pathname/location management utility methods
 */
public class FileUtil {
    public static final String DEPLOY = "deploy";
    public static final String REDEPLOY = "redeploy";
    public static final String TRANSFORMATION_RULE = "transformationRule";
    public static final String INSTANCE_ROOT = System.getProperty("com.sun.aas.instanceRoot");
    public static final String GEN_XML_DIR = INSTANCE_ROOT + File.separator + "generated" + File.separator + "xml";
    public static final String GEN_XML_APP_DIR = GEN_XML_DIR + File.separator + "j2ee-apps";
    public static final String GEN_XML_MOD_DIR = GEN_XML_DIR + File.separator + "j2ee-modules";

    public static String getUploadDir() throws Exception {
        return AdminService.getAdminService().getGUITempDirPath(); //TODO: Get directory from admin gui side instead of depending on external module
    }
    
    public static boolean isEARFile(File file) {
        try {
            JarFile jar = new JarFile(file);
            ZipEntry result = jar.getEntry("META-INF/application.xml");
            jar.close();
            return result != null;
        } catch (IOException ex) {
            return false;
        }
    }

    public static boolean isWARFile(File file) {
        try {
            JarFile jar = new JarFile(file);
            ZipEntry result = jar.getEntry("WEB-INF/web.xml");
            jar.close();
            return result != null;
        } catch (IOException ex) {
            return false;
        }
    }

    public static boolean isEJBJar(File file) {
        try {
            JarFile jar = new JarFile(file);
            ZipEntry result = jar.getEntry("META-INF/ejb-jar.xml");
            jar.close();
            return result != null;
        } catch (IOException ex) {
            return false;
        }
    }

    public static boolean isJarFile(File file) {
	//Check whether this is a valid file
	//for now return true.
        try {
            boolean result = false;

            if(file.getName().endsWith(".jar")) {
               JarFile jar = new JarFile(file);
               if ( jar != null ) {
                  result = jar.entries().hasMoreElements();
               } 
               jar.close();
               return result ;
            } else {
	       return false;
            }
          
        } catch (IOException ex) {
            return false;
        }
    }

    public static boolean isRARFile(File file) {
        try {
            JarFile jar = new JarFile(file);
            ZipEntry result = jar.getEntry("META-INF/ra.xml");
            jar.close();
            return result != null;
        } catch (IOException ex) {
            return false;
        }
    }

    public static boolean isAppClientJar(File file) {
        try {
            JarFile jar = new JarFile(file);
            ZipEntry result = jar.getEntry("META-INF/application-client.xml");
            jar.close();
            return result != null;
        } catch (IOException ex) {
            return false;
        }
    }
    
    public static void extractMbeanJarFile(String domainRoot, String fileName ) throws IOException {
            File f = new File(fileName);
            if(FileUtil.isJarFile(f)) 
            {
               //We have to extract it into mbeans directory for the classloader to load it.
               JarExtract.extract(fileName, domainRoot+"/applications/mbeans");
            }
    }
    
}
