/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.admingui.view;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.NavigationException;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.command.Command;
import com.iplanet.jato.command.CommandEvent;
import com.iplanet.jato.command.CommandException;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.ChildContentDisplayEvent;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.event.DisplayEvent;

import com.sun.enterprise.tools.guiframework.exception.ChildNotRegisteredException;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import com.sun.enterprise.tools.guiframework.view.DescriptorContainerView;
import com.sun.enterprise.tools.guiframework.view.DescriptorViewHelper;

import com.sun.web.ui.servlet.help2.MastheadViewBean;


/**
 *
 */
public class DescriptorCCHelp2MastheadViewBean extends MastheadViewBean implements DescriptorContainerView, Command {

    /**
     *	Constructor
     *
     *	@param	ctx	The RequestContext
     *	@param	name	The name of the ViewBean
     *	@param	desc	The ViewDescriptor
     */
    public DescriptorCCHelp2MastheadViewBean(RequestContext ctx, String name, ViewDescriptor desc) {
	super();
	setRequestContext(ctx);
	setName(name);
	setViewDescriptor(desc);
	registerViewDescriptorChildren();
    }



    //////////////////////////////////////////////////////////////////////
    //                         Command Methods                          //
    //////////////////////////////////////////////////////////////////////

    /**
     *	This method is invoked to dispatch all requests to the appropriate
     *	place.
     *
     *	@param event	The command event, contains information pertinent to
     *			to the invocation of this command
     *
     *	@throws CommandException	Thrown if an error occurs executing
     *					the command
     */
    public void execute(CommandEvent event) throws CommandException {
	DescriptorViewHelper.execute(
	    getRequestContext(), (View)event.getSource(), event);
    }



    ////////////////////////////////////////////////////////////
    //           DescriptorContainerView Methods              //
    ////////////////////////////////////////////////////////////

    /**
     *	This method sets the ViewDescriptor for this View.
     */
    protected void setViewDescriptor(ViewDescriptor desc) {
	_viewDesc = desc;
    }


    /**
     *	This method retrieves this View ViewDescriptor.
     *
     *	@return This View's ViewDescriptor.
     */
    public ViewDescriptor getViewDescriptor() {
	return _viewDesc;
    }


    public View createChild(String name) {
	View child = null;
	try {
	    // Try to create the Child via a child descriptor
	    child = DescriptorViewHelper.createChild(this, name);
	} catch (ChildNotRegisteredException ex) {
	    // Some children have built-in support via the super class
	    child = super.createChild(name);
	}

	// return the child
	return child;
    }


    /**
     *	Make forwarding easy
     */
    public void forwardTo(RequestContext requestContext) throws NavigationException {
	super.forwardTo(requestContext);
    }



    //////////////////////////////////////////////////////////////////////
    //                          Event Methods                           //
    //////////////////////////////////////////////////////////////////////

    /**
     *	This method dispatches BeginDisplay events to each registered
     *	BeginDisplay event handler according the the ViewDescriptor.
     *	This method is defined in ContainerView, but it is important to
     *	to override this.
     *
     *	@param event	The DisplayEvent, created internally by JATO
     */
    public void beginDisplay(DisplayEvent event) throws ModelControlException {
	DescriptorViewHelper.beginDisplay(this, event);
	super.beginDisplay(event);
    }


    /**
     *	This method is defined in ContainerView, but it is important to 
     *	override this.
     */
    public boolean beginChildDisplay(ChildDisplayEvent event) {
	try {
	    return DescriptorViewHelper.beginChildDisplay(this, event);
	} catch (Exception ex) {
	    throw new FrameworkException(ex, getViewDescriptor(), this);
	}
    }


    /**
     *	This method is defined in ContainerView, but it is important to 
     *	override this.
     */
    public String endChildDisplay(ChildContentDisplayEvent event) throws ModelControlException {
	return DescriptorViewHelper.endChildDisplay(this, event);
    }


    /**
     *	This method is defined in ContainerView, but it is important to 
     *	override this.
     */
    public void endDisplay(DisplayEvent event) {
	DescriptorViewHelper.endDisplay(this, event);
	super.endDisplay(event);
    }


    /**
     *	<P>Children need to be registered so that values can be submitted back
     *	to DisplayFields, CommandFields can be handled, and containers which
     *	contain these things will work.  So... to ensure that
     *	DescriptorContainerView's work, the following
     *	registerViewDescriptorChildren() method must be implemented.  This
     *	method is named this way to avoid accidentally overriding a
     *	registerChildren method.  Since JATO did not make this part of an
     *	interface, we cannot do super.registerChildren(). <B>This method should
     *	be invoked from the constructor after the ViewDescriptor has been
     *	set.</B>  Most implementations of this method should do the
     *	following:</P>
     *
     *	<BLOCKQUOTE><CODE>
     *	    DescriptorViewHelper.registerViewDescriptorChildren(getViewDescriptor(), this);
     *	</CODE></BLOCKQUOTE>
     *
     */
    public void registerViewDescriptorChildren() {
	DescriptorViewHelper.registerViewDescriptorChildren(getViewDescriptor(), this);
    }


    private ViewDescriptor _viewDesc = null;
}
