/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the "License").  You may not use this file except
 * in compliance with the License.
 *
 * You can obtain a copy of the license at
 * glassfish/bootstrap/legal/CDDLv1.0.txt or
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * HEADER in each file and include the License file at
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable,
 * add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your
 * own identifying information: Portions Copyright [yyyy]
 * [name of copyright owner]
 */
package com.sun.enterprise.tools.jsfext.component.factory.basic;

import com.sun.enterprise.tools.jsfext.component.factory.ComponentFactoryBase;
import com.sun.enterprise.tools.jsfext.layout.descriptor.LayoutComponent;
import com.sun.enterprise.tools.jsfext.component.LavaChannelHref;

import com.sun.web.ui.component.Hyperlink;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;


/**
 *  <p>	This factory is responsible for instantiating a <code>Hyperlink
 *	UIComponent</code> that is configured to submit a LavaChannel
 *	request.</p>
 *
 *  <p>	All properties are passed through the underlying
 *	<code>Hyperlink</code> UIComponent.</p>
 *
 *  @author Ken Paulsen	(ken.paulsen@sun.com)
 */
public class LavaChannelHrefFactory extends ComponentFactoryBase {

    /**
     *	<p> This is the factory method responsible for creating the
     *	    <code>UIComponent</code>.  You should specify the
     *	    <code>lavaTarget</code> for this component.  See
     *	    {@link #LAVA_CHANNEL_TARGET}.</p>
     *
     *	@param	context	    The <code>FacesContext</code>
     *	@param	descriptor  The {@link LayoutComponent} descriptor associated
     *			    with the requested <code>UIComponent</code>.
     *	@param	parent	    The parent <code>UIComponent</code>
     *
     *	@return	The newly created <code>LavaChannelHref</code>.
     */
    public UIComponent create(FacesContext context, LayoutComponent descriptor, UIComponent parent) {
	// Create the UIComponent
	Hyperlink href = new Hyperlink();

	// This needs to be done here (before setOptions) so that $...{...}
	// expressions can be resolved... may want to defer these?
	if (parent != null) {
	    addChild(context, descriptor, parent, href);
	}

	// Set all the attributes / properties
	setOptions(context, descriptor, href);

	// Setup the LavaChannel Request
// FIXME: support javascript function to handle return value
// FIXME: support extra NVPs??  Maybe not needed?  UIParameter instead?  May be easier as a &n=v&... string.
	String clientId = href.getClientId(context);
// FIXME: XXX DEAL WITH THIS!!!
// FIXME: BUG: JSF automatically converts the '&' characters in attributes to &amp; this causes a problem... talk to LH and JSF about this.
//	String extraNVPs = "'&" + clientId + "_submittedField=" + clientId + "'";
	String extraNVPs = "'" + clientId + "_submittedField=" + clientId + "'";
	String jsHandlerFunction = "null";
// FIXME: Perhaps we can support multiple targets?  If I render multiple sections of the UIComponent tree and return a document describing the results...
	String target = (String) descriptor.getEvaluatedOption(context, LAVA_CHANNEL_TARGET, href);
	if ((target == null) || target.equals("")) {
	    target = clientId;
	}
	href.setOnClick("submitLavaChannel('" + target + "', " +extraNVPs + ", " + jsHandlerFunction + "); return false;");

	// Return the component
	return href;
    }

    /**
     *	<p> This is the property that specifies the target for the
     *	    lavaChannelRequest.  If not specified, the link itself will be the
     *	    target (which is likely not the desired target of the
     *	    XMLHttpRequest).  The target should be the clientId (i.e. the "id"
     *	    you see in the HTML source) of the UIComponent.</p>
     *
     *	<p> The property name is: <code>lavaTarget</code>.</p>
     */
    public static final String LAVA_CHANNEL_TARGET =	"lavaTarget";
}
