/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.event.descriptors;

import com.iplanet.jato.RequestContext;

import com.sun.enterprise.tools.guiframework.FrameworkDescriptor;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.util.PermissionChecker;
import com.sun.enterprise.tools.guiframework.util.Util;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;

import java.lang.reflect.Method;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;


/**
 *  This class holds information about "call" element.  A "call"
 *  refers to a handler and provides the inputs needed for the
 *  handler.  A "call" is either a child of an EventDescriptor, or a
 *  child of handler definition.
 */
public class UseHandlerDescriptor implements FrameworkDescriptor {

    /**
     *	Constructor.
     *
     *	@param	parent	The EventDescriptor which contains this Handler.
     */
    public UseHandlerDescriptor(FrameworkDescriptor parent, HandlerDescriptor handlerDesc) {
	setParent(parent);
	setHandlerDescriptor(handlerDesc);
    }


    /**
     *	This method returns the EventDescriptor that contains this handler.
     *
     *	@return The parent descriptor
     */
    public FrameworkDescriptor getParent() {
	return _parent;
    }


    /**
     *
     */
    public HandlerDescriptor getHandlerDescriptor() {
	return _handler;
    }


    /**
     *	This method sets the parent EventDescriptor.
     *
     *	@param	parent	The parent EventDescriptor
     */
    protected void setParent(FrameworkDescriptor parent) {
	if (parent == null) {
	    throw new FrameworkException("You must provide a the " +
		"FrameworkDescriptor which contains this " +
		"UseHandlerDescriptor!");
	}
	_parent = parent;
    }


    /**
     *	This method sets the handler descriptor used by this "useHandler".
     */
    protected void setHandlerDescriptor(HandlerDescriptor handler) {
	_handler = handler;
    }


    /**
     *	Accessor for the ifCheck String
     */
    public String getIfCheck() {
	return _ifCheck;
    }


    /**
     *	Setter for the ifCheck String
     */
    public void setIfCheck(String ifCheck) {
	_ifCheck = ifCheck;
    }


    /**
     *	This method uses a PermissionChecker to evaluate the "ifCheck
     *	String".  The ifCheck String is a boolean expression, see
     *	PermissionChecker for details.  If the ifCheck String is null,
     *	then this method will return true.  $(attribute-name) entries within
     *	the ifCheck String will be evaluated; they should evaluate to the
     *	Strings "true" or "false".  
     *
     *	@param	vd	The ViewDescriptor
     *
     *	@return	True if this Mapping has permission, false if not
     */
    public boolean hasPermission(ViewDescriptor vd) {
	// Get the if="" value
	String ifCheck = getIfCheck();
	if ((ifCheck == null) || (ifCheck.trim().length() == 0)) {
	    // Default is to allow access
	    return true;
	}

	// Delegate to permission checker to determine result
	return new PermissionChecker(ifCheck, vd).hasPermission();
    }


    /**
     *
     */
    public void setInputValue(String name, Object value) {
	_inputs.put(name, value);
    }


    /**
     *
     */
    public Object getInputValue(String name) {
	return _inputs.get(name);
    }


    /**
     *
     */
    public void setOutputMapping(String name, String targetKey, String targetType) {
	if ((name == null) || (name.length() == 0)) {
	    throw new FrameworkException("Name is required!");
	}
	if (targetKey != null) {
	    targetKey = targetKey.trim();
	    if (targetKey.length() == 0) {
		targetKey = null;
	    }
	}
	if (targetType != null) {
	    targetType = targetType.trim();
	    if (targetType.length() == 0) {
		targetType = null;
	    }
	}
	String outputDesc[] = new String[2];
	outputDesc[0] = targetKey;
	outputDesc[1] = targetType;
	_outputs.put(name, outputDesc);
    }


    /**
     *
     */
    public Object getOutputTargetKey(String name) {
	return ((String[])_outputs.get(name))[0];
    }


    /**
     *
     */
    public Object getOutputTargetType(String name) {
	return ((String[])_outputs.get(name))[1];
    }


    /**
     *
     */
    public String[] getOutputMapping(String name) {
	return (String[])_outputs.get(name);
    }


    private FrameworkDescriptor	_parent		= null;
    private String		_ifCheck	= null;
    private HandlerDescriptor 	_handler	= null;
    private Map			_inputs		= new HashMap();
    private Map			_outputs	= new HashMap();
}
