/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.view;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.NavigationException;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.DisplayField;
import com.iplanet.jato.view.DisplayFieldDescriptor;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.ChildContentDisplayEvent;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.event.DisplayEvent;

import com.sun.enterprise.tools.guiframework.exception.ChildNotRegisteredException;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;

import com.sun.web.ui.model.CCDateTimeModelInterface;
import com.sun.web.ui.view.datetime.CCDateTime;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;


/**
 *  LH requires that validateDataInput() be called before the model values
 *  retrieved.  This class will do that automatically if you use getValue(),
 *  however, if you attempt to pull values directly from the model you will
 *  need to ensure this method is called first.
 */
public class DescriptorCCDateTime extends CCDateTime implements DescriptorContainerView, DisplayField {

    /**
     *	Constructor
     *
     *	@param	ctx	The RequestContext
     *	@param	name	The name of the ViewBean
     *	@param	desc	The ViewDescriptor
     */
    public DescriptorCCDateTime(RequestContext ctx, String name, ViewDescriptor desc, ContainerView parent, CCDateTimeModelInterface model) {
	super(parent, model, name);
	setRequestContext(
	    (ctx == null) ? RequestManager.getRequestContext() : ctx);
	setViewDescriptor(desc);
	registerViewDescriptorChildren();
    }


    //////////////////////////////////////////////////////////////////////
    //                  DescriptorContainerView Methods                 //
    //////////////////////////////////////////////////////////////////////

    /**
     *	This method sets the ViewDescriptor for this View.
     */
    protected void setViewDescriptor(ViewDescriptor desc) {
	_viewDesc = desc;
    }


    /**
     *	This method retrieves this View ViewDescriptor.
     *
     *	@return This View's ViewDescriptor.
     */
    public ViewDescriptor getViewDescriptor() {
	return _viewDesc;
    }


    /**
     *
     */
    public View createChild(String name) {
	View child = null;
	try {
	    // Try to create the Child via a child descriptor
	    child = DescriptorViewHelper.createChild(this, name);
	} catch (ChildNotRegisteredException ex) {
	    // Some children have built-in support via the super class
	    child = super.createChild(name);
	}

	// return the child
	return child;
    }


    /**
     *	Make forwarding easy
     */
    public void forwardTo(RequestContext requestContext) throws NavigationException {
	getParentViewBean().forwardTo(requestContext);
    }


    //////////////////////////////////////////////////////////////////////
    //                       DisplayField Methods                       //
    //////////////////////////////////////////////////////////////////////

    /**
     * Returns the current value of this view.  In most cases, if this view
     * is associated with a model, this value will the current value of the 
     * model.
     * 
     * @return	The current value.  If there are multiple current values for 
     *			this view, only the first value is returned.  If there is no 
     *			value, this method returns null.
     */
    public Object getValue() {
	// Only call this if values have been submitted
	if (((DisplayField)getChild(START_DATE_TEXT)).getValue() != null) {
	    // We want to make sure to call this at most once per request
	    if (_validateCheck != getRequestContext()) {
		validateDataInput();
		_validateCheck = getRequestContext();
	    }
	}
	return getModel().getStartDateTime();
    }


    /**
     * This method returns either the toString() representation of a non-null
     * displayField's value, or a blank string whenever the value is null 
     *
     * @return a string representation of the value, guaranteed to be non-null 
     */
    public String stringValue() {
	Object value = getValue();
	if (value == null) {
	    return "";
	}
	return value.toString();
    }


    /**
     * Sets the current value of this view.  This method overwrites any current
     * value or values.  If multiple values were present previously, they
     * are all discarded.  If this view is associated with a model, this value
     * should be propagated to the model.
     * 
     * @param	value
     *			The value to set in this view
     */
    public void setValue(Object value) {
	if (value == null) {
	    return;
	}
	Date date = null;
	if (value instanceof Date) {
	    date = (Date)value;
	} else {
	    try {
		DateFormat df = DateFormat.getDateTimeInstance(
		    DateFormat.MEDIUM,
		    DateFormat.MEDIUM,
		    getRequestContext().getRequest().getLocale());
		date = df.parse((String)value);
	    } catch (ParseException ex) {
		throw new FrameworkException(
		    "Unable to set CCDateTime value: '"+value+
		    "' for CCDateTime field '"+getName()+"'.", ex,
		    getViewDescriptor(), this);
	    }
	}
	getModel().setStartDateTime(date);
    }


    /**
     * Returns this view's current set of values.  In most cases, if this view
     * is associated with a model, these values will be the current values of 
     * the model.
     * 
     * @return	The current set of values.  If there is no value, this method
     *			returns an array of zero length.
     */
    public Object[] getValues() {
	return new Object[] {getValue()};
    }


    /**
     * Sets this view's current set of values.  All previous values are 
     * discarded.  If this view is associated with a model, this set of values 
     * should be propagated to the model.
     * 
     * @param	values
     *			The set of values to set in this view
     */
    public void setValues(Object[] values) {
	throw new FrameworkException(
	    "setValues() not supported.", getViewDescriptor(), this);
    }


    /**
     * Returns the DisplayFieldDescriptor
     * 
     * @return  This field's DisplayFieldDescriptor, which may be null if
     *			a descriptor was not specified during construction
     */
    public DisplayFieldDescriptor getDescriptor() {
	return null;
    }


    //////////////////////////////////////////////////////////////////////
    //                           Event Methods                          //
    //////////////////////////////////////////////////////////////////////

    /**
     *	This method dispatches BeginDisplay events to each registered
     *	BeginDisplay event handler according the the ViewDescriptor.
     *	This method is defined in ContainerView, but it is important to
     *	to override this.
     *
     *	@param event	The DisplayEvent, created internally by JATO
     */
    public void beginDisplay(DisplayEvent event) throws ModelControlException {
	DescriptorViewHelper.beginDisplay(this, event);
	super.beginDisplay(event);
    }


    /**
     *	This method is defined in ContainerView, but it is important to 
     *	override this.
     */
    public boolean beginChildDisplay(ChildDisplayEvent event) throws ModelControlException {
	try {
	    return DescriptorViewHelper.beginChildDisplay(this, event);
	} catch (Exception ex) {
	    throw new FrameworkException(ex, getViewDescriptor(), this);
	}
    }


    /**
     *	This method is defined in ContainerView, but it is important to 
     *	override this.
     */
    public String endChildDisplay(ChildContentDisplayEvent event) throws ModelControlException {
	return DescriptorViewHelper.endChildDisplay(this, event);
    }


    /**
     *	This method is defined in ContainerView, but it is important to 
     *	override this.
     */
    public void endDisplay(DisplayEvent event) {
	DescriptorViewHelper.endDisplay(this, event);
	super.endDisplay(event);
    }


    /**
     *	<P>Children need to be registered so that values can be submitted back
     *	to DisplayFields, CommandFields can be handled, and containers which
     *	contain these things will work.  So... to ensure that
     *	DescriptorContainerView's work, the following
     *	registerViewDescriptorChildren() method must be implemented.  This
     *	method is named this way to avoid accidentally overriding a
     *	registerChildren method.  Since JATO did not make this part of an
     *	interface, we cannot do super.registerChildren(). <B>This method should
     *	be invoked from the constructor after the ViewDescriptor has been
     *	set.</B>  Most implementations of this method should do the
     *	following:</P>
     *
     *	<BLOCKQUOTE><CODE>
     *	    DescriptorViewHelper.registerViewDescriptorChildren(getViewDescriptor(), this);
     *	</CODE></BLOCKQUOTE>
     *
     */
    public void registerViewDescriptorChildren() {
	DescriptorViewHelper.registerViewDescriptorChildren(getViewDescriptor(), this);
    }


    private RequestContext _ctx = null;
    private RequestContext _validateCheck = null;
    private ViewDescriptor _viewDesc = null;
}
