/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * ViewXMLEntityResolver.java
 *
 * Created on December 9, 2003, 11:08 AM
 */

package com.sun.enterprise.tools.guiframework.view;

import com.iplanet.jato.RequestManager;

import java.io.InputStream;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import java.io.File;
import javax.servlet.ServletContext;

/* This entity reolver looks for xml & dtd files that are included as SYSTEM entities
 * in the java class-path. If the xml file is not found in the class path the
 * resolver returns null, allowing default mechanism to search for the file
 * on the file system
 */

public class ViewXMLEntityResolver implements EntityResolver {
    public InputSource resolveEntity (String publicId, String systemId) {
        if (systemId != null && (systemId.endsWith(".xml") || systemId.endsWith(".dtd"))) {
            /*
            System.out.println("(1)publicId = " + publicId + " systemId = " + systemId);
            int lastIndex = systemId.lastIndexOf("/");
            System.out.println("lastIndex =  " + lastIndex);
            if (lastIndex >= 0) {
                systemId = systemId.substring(lastIndex, systemId.length());
            }
            System.out.println("(2)publicId = " + publicId + " systemId = " + systemId);
             */
            if (systemId.startsWith("file:///")) {
                systemId = systemId.substring(8); // remove file:/// from systemid
            }
            InputStream resourceStream = getClass().getClassLoader().getResourceAsStream(systemId);
            if (resourceStream != null) {
                return new InputSource(resourceStream);
            }
        }
      // use the default behaviour
        return null;
    }
}