/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.view.descriptors;

import com.iplanet.jato.ModelManager;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.DisplayField;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.view.ContainerViewBase;

import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.DescriptorCCActionTable;

import com.sun.web.ui.model.CCActionTableModelInterface;

import java.io.InputStream;


/**
 *
 */
public class CCActionTableDescriptor extends ViewDescriptor {

    /**
     *	Constructor
     */
    public CCActionTableDescriptor(String name) {
	super(name);
    }

    
    public void registerChildren(ContainerViewBase instance) {
    	// Invoke the super registerChild
        super.registerChildren(instance);

	getModel().registerChildren(instance);
    }

    
    /**
     *	This method creates empty descriptors on the fly for fields that are
     *	defined by the underlying model.
     */
    public ViewDescriptor getChildDescriptor(String name) {
    	// Do the normal stuff if we can...
	ViewDescriptor desc = super.getChildDescriptor(name);
	if (desc != null) {
	    return desc;
	}

	// Do we need to create a descriptor on the fly?
	CCActionTableModelInterface model = getModel();
        if (model != null && model.isChildSupported(name)) {
	    // YES
	    desc = new CCActionTableChildDescriptor(name);
	    // NOTE: This call is safe (mostly), because although we are
	    // NOTE: modifying a static structure... this change is applicable
	    // NOTE: to all users.  However, there is a slight possibility of
	    // NOTE: of a sync. problem... not worth worrying about now.  If
	    // NOTE: this does become a problem, just remove the
	    // NOTE: addChildDescriptor() line below.
	    addChildDescriptor(desc);
	    return desc;
	}

	return null;
    }
    
    /**
     *	This is a factory method for CCActionTable instances.
     *
     *	@param	ctx	The RequestContext
     *	@param	container	The container for the newly created 
     */
    public View getInstance(RequestContext ctx, ContainerView container, String name) {
	return new DescriptorCCActionTable(ctx, container, name, this, getModel());
    }

    /**
     *	Call this method when the XML changes and the model needs to reparse it.
     */
    public void resetXML() {
        getModel(true);
    }
    
    /**
     *	This method returns the model associated with this View.
     */
    public CCActionTableModelInterface getModel() {
        return getModel(false);
    }
    
    private CCActionTableModelInterface getModel(boolean resetXML) {
	// Determine if the session should be used w/ the model manager.
	boolean fromSession = shouldGetModelFromSession();
	boolean toSession = shouldPutModelToSession();
	String value = getModelInstanceName();

	// Use the ModelManager to create/get the model
	ModelManager mgr = RequestManager.getRequestContext().getModelManager();
	CCActionTableModelInterface model =
	    (CCActionTableModelInterface)mgr.getModel(
		CCActionTableModelInterface.class,
		value, fromSession, toSession);

	// Make sure the XML file is set on the Model
	if (resetXML || model.getDocument() == null) {
	    // Get the XML document
 	    InputStream in = getXMLFileAsStream();
	    model.setDocument(in);
	    try {
		in.close();
	    } catch (java.io.IOException ex) {
		// Ignore
	    }

	    // Other values set in this "if" statement provide defaults that
	    // the user may choose to override

	    // Set the default Primary Sort Name
	    value = (String)getParameter(PRIMARY_SORT_NAME);
	    if (value != null) {
		model.setPrimarySortName(value);
	    }

	    // Set the default Primary Sort Order
	    value = (String)getParameter(PRIMARY_SORT_ORDER);
	    if (value != null) {
		model.setPrimarySortOrder(value);
	    }

	    // Set the default Secondary Sort Name
	    value = (String)getParameter(SECONDARY_SORT_NAME);
	    if (value != null) {
		model.setSecondarySortName(value);
	    }

	    // Set the default Secondary Sort Order
	    value = (String)getParameter(SECONDARY_SORT_ORDER);
	    if (value != null) {
		model.setSecondarySortOrder(value);
	    }
	}

	// Check to see if the selection type was specified
	value = (String)getParameter(ROW_SELECTION_TYPE);
	if (value != null) {
	    model.setRowSelectionType(value);
	}

	return model;
    }

    /**
     *	<P> This parameter key allows the row selection type to be
     *	    provided.</P>
     *
     *	<P>Valid values are:</P>
     *
     *	<UL><LI>CCActionTableModelInterface.MULTIPLE</LI>
     *	    <LI>CCActionTableModelInterface.SINGLE</LI>
     *	    <LI>CCActionTableModelInterface.NONE</LI></UL>
     */
    public static final String ROW_SELECTION_TYPE   =	"rowSelectionType";

    /**
     *	<P> This parameter key allows the primary sort name to be set.</P>
     */
    public static final String PRIMARY_SORT_NAME    =	"primarySortName";

    /**
     *	<P> This parameter key allows the primary sort order to be set.</P>
     *
     *	<P>Valid values are:</P>
     *
     *	<UL><LI>CCActionTableModelInterface.ASCENDING</LI>
     *	    <LI>CCActionTableModelInterface.DESCENDING</LI></UL>
     */
    public static final String PRIMARY_SORT_ORDER   =	"primarySortOrder";

    /**
     *	<P> This parameter key allows the secondary sort name to be set.</P>
     */
    public static final String SECONDARY_SORT_NAME  =	"secondarySortName";

    /**
     *	<P> This parameter key allows the secondary sort order to be set.</P>
     *
     *	<P>Valid values are:</P>
     *
     *	<UL><LI>CCActionTableModelInterface.ASCENDING</LI>
     *	    <LI>CCActionTableModelInterface.DESCENDING</LI></UL>
     */
    public static final String SECONDARY_SORT_ORDER =	"secondarySortOrder";
}
