/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.view.descriptors;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.html.SelectableGroup;
import com.iplanet.jato.view.html.SelectableGroupImpl;
import com.iplanet.jato.view.html.OptionList;
import com.iplanet.jato.view.html.Option;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.sun.web.ui.view.html.CCDropDownMenu;

import com.sun.enterprise.tools.guiframework.exception.FrameworkException;

import java.util.ArrayList;
import java.util.List;

/**
 *  Unfortunately, this class has to exist to support Lockhart tags.  They are
 *  not current with JATO and cannot use JATO BasicChoiceDisplayField's.  Once,
 *  Lockhart supports those fields, then this class will be deprecated in favor
 *  of ChoiceFieldDescriptor.
 */
public class CCDropDownMenuDescriptor extends SelectFieldDescriptor {

    /**
     *	This constructor creates a DisplayFieldDescriptor.  Name is
     *	required to create a SelectFieldDescriptor.
     *
     *	@param name		Instance name for the described SelectField
     */
    public CCDropDownMenuDescriptor(String name) {
	super(name);
    }


    /**
     *
     */
    public View getInstance(RequestContext ctx, ContainerView container, String name) {
	// Create the CCDropDownMenu
	String initialValue = (String)getParameter("initialValue");
	CCDropDownMenu choice = new CCDropDownMenu(
	    container, name, getModelFieldName(), initialValue);

	// Set the options
        setOptions(choice);

	// Set the extraHtml
	setExtraHtml(choice);

	// Set the commandChild (turns this into a navigation drop down)
	String commandChild = (String)getParameter(COMMAND_CHILD);
	if ((commandChild != null) && !commandChild.equals("")) {
	    choice.setCommandChild(commandChild);
	}
	return choice;
    }


    /**
     *	This parameter key ("commandChild") allows the CommandField child
     *	name to be supplied so that JavaScript will be generated to submit
     *	the form targetting the given CommandChild when a selection is made
     *	for this DropDownMenu.
     */
    public static final String COMMAND_CHILD =	    "commandChild";
}
