/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.view.descriptors;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.sun.web.ui.view.html.CCImageField;


/**
 *
 */
public class CCImageFieldDescriptor extends DisplayFieldDescriptor {

    /**
     *	Constructor
     */
    public CCImageFieldDescriptor(String name) {
	super(name);
    }

    /**
     *	<p> This is a factory method for CCImageField instances.  It supports
     *	    the following parameters:<p>
     *
     *	<ul><li>{@link DisplayFieldDescriptor#DEFAULT_VALUE} ("defaultValue") --
     *		Sets initial value</li>
     *	    <li>{@link DisplayFieldDescriptor#MODEL_FIELD_NAME}
     *		("modelFieldName") -- Sets the Model field name for binding</li>
     *	    <li>{@link #ALIGN} ("align") --
     *		Sets the CCImageField align property.</li>
     *	    <li>{@link #ALT} ("alt") --
     *		Sets the CCImageField alt property.</li>
     *	    <li>{@link #BORDER} ("border") --
     *		Sets the CCImageField border property.</li>
     *	    <li>{@link #ELEMENT_ID} ("elementId") --
     *		Sets the CCImageField elementId property.</li>
     *	    <li>{@link #HEIGHT} ("height") --
     *		Sets the CCImageField height property.</li>
     *	    <li>{@link #HSPACE} ("hspace") --
     *		Sets the CCImageField hspace property.</li>
     *	    <li>{@link #IS_MAP} ("isMap") --
     *		Sets the CCImageField isMap property.</li>
     *	    <li>{@link #LONG_DESC} ("longDesc") --
     *		Sets the CCImageField longDesc property.</li>
     *	    <li>{@link #TITLE} ("title") --
     *		Sets the CCImageField title property.</li>
     *	    <li>{@link #USE_MAP} ("useMap") --
     *		Sets the CCImageField useMap property.</li>
     *	    <li>{@link #VSPACE} ("vspace") --
     *		Sets the CCImageField vspace property.</li>
     *	    <li>{@link #WIDTH} ("width") --
     *		Sets the CCImageField width property.</li>
     *
     *	@param	ctx		The RequestContext
     *	@param	container	The container for the new CCImageField
     */
    public View getInstance(RequestContext ctx, ContainerView container, String name) {
	CCImageField image = new CCImageField(container, name, getInitialValue());
	setBoundName(image);

	// Align
	String value = (String)getParameter(ALIGN);
	if (value != null) {
	    image.setAlign(value);
	}

	// Alt
	value = (String)getParameter(ALT);
	if (value != null) {
	    image.setAlt(value);
	}

	// Border
	value = (String)getParameter(BORDER);
	if (value != null) {
	    image.setBorder(Integer.parseInt(value));
	}

	// ElementID
	value = (String)getParameter(ELEMENT_ID);
	if (value != null) {
	    image.setElementId(value);
	}

	// Height
	value = (String)getParameter(HEIGHT);
	if (value != null) {
	    image.setHeight(Integer.parseInt(value));
	}

	// HSpace
	value = (String)getParameter(HSPACE);
	if (value != null) {
	    image.setHspace(Integer.parseInt(value));
	}

	// IsMap
	value = (String)getParameter(IS_MAP);
	if (value != null) {
	    image.setIsMap(Boolean.valueOf(value).booleanValue());
	}

	// LongDesc
	value = (String)getParameter(IS_MAP);
	if (value != null) {
	    image.setLongDesc(value);
	}

	// Title
	value = (String)getParameter(TITLE);
	if (value != null) {
	    image.setTitle(value);
	}

	// UseMap
	value = (String)getParameter(USE_MAP);
	if (value != null) {
	    image.setUseMap(value);
	}

	// VSpace
	value = (String)getParameter(VSPACE);
	if (value != null) {
	    image.setVspace(Integer.parseInt(value));
	}

	// Width
	value = (String)getParameter(WIDTH);
	if (value != null) {
	    image.setWidth(Integer.parseInt(value));
	}

	return image;
    }

    /**
     *	<p> Parameter name to set the CCImageField align property value
     *	    ("align").</p>
     */
    public static final String	ALIGN	= "align";

    /**
     *	<p> Parameter name to set the CCImageField alt property value
     *	    ("alt").</p>
     */
    public static final String	ALT	= "alt";

    /**
     *	<p> Parameter name to set the CCImageField border property value
     *	    ("border").</p>
     */
    public static final String	BORDER	= "border";

    /**
     *	<p> Parameter name to set the CCImageField elementId property value
     *	    ("elementId").</p>
     */
    public static final String	ELEMENT_ID	= "elementId";

    /**
     *	<p> Parameter name to set the CCImageField height property value
     *	    ("height").</p>
     */
    public static final String	HEIGHT	= "height";

    /**
     *	<p> Parameter name to set the CCImageField hspace property value
     *	    ("hspace").</p>
     */
    public static final String	HSPACE	= "hspace";

    /**
     *	<p> Parameter name to set the CCImageField isMap property value
     *	    ("isMap").</p>
     */
    public static final String	IS_MAP	= "isMap";

    /**
     *	<p> Parameter name to set the CCImageField longDesc property value
     *	    ("longDesc").</p>
     */
    public static final String	LONG_DESC	= "longDesc";

    /**
     *	<p> Parameter name to set the CCImageField title property value
     *	    ("title").</p>
     */
    public static final String	TITLE	= "title";

    /**
     *	<p> Parameter name to set the CCImageField useMap property value
     *	    ("useMap").</p>
     */
    public static final String	USE_MAP	= "useMap";

    /**
     *	<p> Parameter name to set the CCImageField vspace property value
     *	    ("vspace").</p>
     */
    public static final String	VSPACE	= "vspace";

    /**
     *	<p> Parameter name to set the CCImageField width property value
     *	    ("width").</p>
     */
    public static final String	WIDTH	= "width";
}
