/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * OS.java
 *
 * Created on December 8, 2001, 5:48 PM
 */

package com.sun.enterprise.config.backup.util;

import java.io.*;

/**
 *
 * @author  bnevins
 * @version 
 */
public class OS 
{
	private OS() 
	{
	}
	
	///////////////////////////////////////////////////////////////////////////
	
	public static boolean isWindows()
	{
		return File.separatorChar == '\\';
	}
	
	///////////////////////////////////////////////////////////////////////////
	
	public static boolean isUNIX()
	{
		return File.separatorChar == '/';
	}
	
	///////////////////////////////////////////////////////////////////////////
	
	public static boolean isUnix()
	{
		// convenience method...
		return isUNIX();
	}
	
	///////////////////////////////////////////////////////////////////////////
	
	public static boolean isSun()
	{
		return is("sun");
	}
	
	///////////////////////////////////////////////////////////////////////////
	
	public static boolean isLinux()
	{
		return is("linux");
	}
	
	///////////////////////////////////////////////////////////////////////////
	
	public static boolean isWindowsForSure()
	{
		return is("windows") && isWindows();
	}

	///////////////////////////////////////////////////////////////////////////
	
	private static boolean is(String name)
	{
		String osname = System.getProperty("os.name");
		
		if(osname == null || osname.length() <= 0)
			return false;
		
		// case insensitive compare...
		osname	= osname.toLowerCase();
		name	= name.toLowerCase();
		
		if(osname.indexOf(name) >= 0)
			return true;
		
		return false;
	}

	///////////////////////////////////////////////////////////////////////////
	
	/**
	* @param args the command line arguments
	*/
	public static void main (String args[]) 
	{
		System.out.println("isUNIX() returned: "			+ isUNIX());
		System.out.println("isWindows() returned: "			+ isWindows());
		System.out.println("isWindowsForSure() returned: "	+ isWindowsForSure());
		System.out.println("isSun() returned: "				+ isSun());
		System.out.println("isLinux() returned: "			+ isLinux());
	}
}
