/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.management.config;

import javax.management.ObjectName;
import javax.management.AttributeNotFoundException;
import javax.management.JMException;
import javax.management.Attribute;
import com.sun.enterprise.management.config.AMXConfigImplBase;
import com.sun.enterprise.management.support.Delegate;
	
import com.sun.enterprise.management.support.oldconfig.OldAuthRealmMBean;

import com.sun.appserv.management.config.AuthRealmConfig;


/**
	Configuration for the &lt;auth-realm&gt; element.
*/


public final class AuthRealmConfigImpl  extends AMXConfigImplBase
	//implements AuthRealmConfig
{
		public
	AuthRealmConfigImpl( final Delegate delegate )
	{
		super( delegate );
	}


    static private final String[]   STRING_SIG  = new String[] { String.class.getName() };
    static private final String[]   UPG_SIG  =
        new String[] { String.class.getName(), String.class.getName(), String[].class.getName() };
    
		public void
	addUser( 
	    final String user,
	    final String password,
	    final String[] groupList )
	{
		getDelegate().invoke(
		    "addUser",
		    new Object[] { user, password, groupList },
		    UPG_SIG );
	}
	
		public String[]
	getGroupNames()
	{
	    String[]  result  = null;
	    
	    // offline is implemented as an Attribute (as it should be)
	    // online is implemented (incorrectly) as an operation.
	    try
	    {
		    result  = (String[])getDelegate().invoke( "getGroupNames", null, null );
		}
		catch( Exception e )
		{
		    try
		    {
		        result  = (String[])delegateGetAttributeNoThrow( "GroupNames" );
		    }
		    catch( Exception ee )
		    {
		        // may not be any for this type of realm
		    }
		}
		
		return result;
	}
	
		public String[]
	getUserGroupNames( final String user )
	{
		return (String[])getDelegate().invoke(
		    "getUserGroupNames",
		    new Object[] { user },
		    STRING_SIG );
	}
	
		public String[]
	getUserNames()
	{
	    String[]  result  = null;
	    
	    // offline is implemented as an Attribute (as it should be)
	    // online is implemented (incorrectly) as an operation.
	    try
	    {
		    result  = (String[])getDelegate().invoke( "getUserNames", null, null );
		}
		catch( Exception e )
		{
		    try
		    {
		        result  = (String[])delegateGetAttributeNoThrow( "UserNames" );
		    }
		    catch( Exception ee )
		    {
		        // may not be any for this type of realm
		    }
		}
		
		return result;
	}

		public void
	removeUser( final String user )
	{
		getDelegate().invoke( "removeUser", new Object[] { user }, STRING_SIG );
	}
	
		public void
	updateUser(
	    final String user,
	    final String password,
	    final String[] groupList )
	{
		getDelegate().invoke( "updateUser",
		    new Object[] { user, password, groupList },
		    UPG_SIG );
	}
}










