/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import java.util.Map;
import java.util.Collections;

import javax.management.ObjectName;
import javax.management.AttributeList;


import com.sun.appserv.management.base.XTypes;
import com.sun.enterprise.management.config.AMXConfigImplBase;
import com.sun.enterprise.management.support.Delegate;
import com.sun.enterprise.management.support.oldconfig.OldVirtualServerMBean;
import com.sun.appserv.management.config.VirtualServerConfig;

import com.sun.appserv.management.util.misc.MapUtil;

/**
	Configuration for the &lt;virtual-server&gt; element.
*/


public final class HTTPAccessLogConfigFactory  extends ConfigFactory
{
	private final OldVirtualServerMBean	mOldVirtualServerMBean;
	
		public
	HTTPAccessLogConfigFactory(
		final ConfigFactoryCallback	callbacks ) 
	{
		super( callbacks );
		
		mOldVirtualServerMBean	=
		    getOldConfigProxies().getOldVirtualServerMBean(
		        getConfigName(), getContainerName() );
	}

	/** Key used in createHTTPAccessLog() */
	public static final String	LOG_DIRECTORY_KEY		= "LogDirectory";
	/** Key used in createHTTPAccessLog() */
	public static final String	IP_ONLY_KEY				= "IPOnly";
	
	static private final Map<String,String> PARAM_NAME_OVERRIDES	=
		Collections.unmodifiableMap( MapUtil.newMap( IP_ONLY_KEY, "iponly" ) );
		
		protected Map<String,String>
	getParamNameOverrides()
	{
		return( PARAM_NAME_OVERRIDES );
	}
	
	/**
	 */
		public ObjectName 
	create(
		final boolean	ipOnly,
		final String	logDirectory,
		final Map<String,String>		reserved )
	{
        final String[] requiredParams = new String[]
		{
			IP_ONLY_KEY,	"" + ipOnly,
			LOG_DIRECTORY_KEY,	logDirectory,
		};
		
		final Map<String,String>	params	= initParams( requiredParams, reserved );

		final ObjectName	amxName	= createChild( params );
		
		return( amxName );
	}


		protected void 
	internalRemove( final ObjectName	objectName)
	{
		mOldVirtualServerMBean.removeHttpAccessLog();
	}

		protected ObjectName
	createOldChildConfig( final AttributeList attrs )
	{
		return( mOldVirtualServerMBean.createHttpAccessLog( attrs ) );
	}
}




