/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/src/java/com/sun/enterprise/management/config/JMSHostConfigFactory.java,v 1.4 2006/03/09 20:30:39 llc Exp $
 * $Revision: 1.4 $
 * $Date: 2006/03/09 20:30:39 $
 */
package com.sun.enterprise.management.config;

import java.util.Map;
import java.util.Set;
import java.util.Collections;

import javax.management.ObjectName;
import javax.management.AttributeList;

import com.sun.enterprise.management.support.oldconfig.OldJMSServiceMBean;

import com.sun.appserv.management.config.JMSHostConfigKeys;

import com.sun.appserv.management.util.misc.GSetUtil;

/**
 */
public final class JMSHostConfigFactory
	extends ConfigFactory 
{
	private final OldJMSServiceMBean	mOldJMSServiceMBean;

		public
	JMSHostConfigFactory(
		final ConfigFactoryCallback callbacks,
		final OldJMSServiceMBean	old )
	{
		super( callbacks );
		
		mOldJMSServiceMBean	= old;
	}
	
	private final Set<String>	LEGAL_OPTIONAL_KEYS	= 
		GSetUtil.newUnmodifiableStringSet( 
		JMSHostConfigKeys.HOST_KEY,
		JMSHostConfigKeys.PORT_KEY,
		JMSHostConfigKeys.ADMIN_USER_NAME_KEY,
		JMSHostConfigKeys.ADMIN_PASSWORD_KEY );
	
	    protected Set<String>
	getLegalOptionalCreateKeys()
	{
		return( LEGAL_OPTIONAL_KEYS );
	}
	
		public ObjectName	
	create( String name, Map<String,String> optional )
	{
		final Map<String,String> params = initParams( name, null, optional );
		final ObjectName amxName = createNamedChild( name, params );
		return amxName;
	}

		protected void	
	removeByName( String name )
	{
		mOldJMSServiceMBean.removeJmsHostByName(name);
	}


		protected ObjectName
	createOldChildConfig( final AttributeList translatedAttrs )
	{
		return mOldJMSServiceMBean.createJmsHost( translatedAttrs );
	}
}




