/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;

import javax.management.ObjectName;
import javax.management.Attribute;
import javax.management.AttributeList;

import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.util.jmx.JMXUtil;

import com.sun.enterprise.management.support.oldconfig.OldConnectorConnectionPoolMBean;

/**
	MBean managing all instances of Connector resource.
 */

public final class SecurityMapConfigFactory  extends ConfigFactory
{
		public
	SecurityMapConfigFactory( final ConfigFactoryCallback	callbacks)
	{
		super( callbacks );
	}
	    
	    private OldConnectorConnectionPoolMBean
	getOld()
	{
	    return getOldConfigProxies().getOldConnectorConnectionPool( getContainerName() );
	}

    static private final String USERNAME_KEY    = "username";
    static private final String PASSWORD_KEY    = "password";
    

		public ObjectName
	create(
	    final String name,
	    final String username,
	    final String password,
	    final String[] principals,
	    final String[] userGroups )
	{
	    final String containerName  = getContainerName();
	    
		final OldConnectorConnectionPoolMBean   ccp =
		    getOldConfigProxies().getOldConnectorConnectionPool( containerName );
		    
		final Map<String,Serializable>    params  = new HashMap<String,Serializable>();
		params.put( "name", name );
		params.put( "pool_name", containerName );
		params.put( "principal", principals );
		params.put( "user_group", userGroups );
		
		final AttributeList attrs   = new AttributeList();
		for( final String key : params.keySet() )
		{
		    attrs.add( new Attribute( key, params.get( key ) ) );
		}
		
	    final String    targetName  = null;
		getOld().createSecurityMap( attrs, username, password, targetName );
		// doesn't return the ObjectName; returns null!
		final ObjectName    oldObjectName  = ccp.getSecurityMapByName( name );
		
		final ObjectName	amxName	= finish( oldObjectName, null );
		
		return( amxName );
	}
	
	
		protected void
	removeByName( final String name )
	{
	    getOld().removeSecurityMapByName( name );
    }				
}







