/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import java.util.Set;

import javax.management.ObjectName;
import javax.management.Attribute;

import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.config.SecurityMapConfig;

import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.misc.ExceptionUtil;
import com.sun.appserv.management.util.misc.StringUtil;

import com.sun.enterprise.management.config.AMXConfigImplBase;

import com.sun.enterprise.management.support.Delegate;
import com.sun.enterprise.management.support.AMXAttributeNameMapper;

import com.sun.enterprise.management.support.oldconfig.OldSecurityMap;

/**
	@since Appserver 9.0
*/
public final class SecurityMapConfigImpl extends AMXConfigImplBase
{
        public
    SecurityMapConfigImpl( final Delegate delegate )
    {
        super( delegate );
    }

		protected void
	addCustomMappings( final AMXAttributeNameMapper mapper )
	{
	    super.addCustomMappings( mapper );
	    
		mapper.matchName( "PrincipalNames", "Principal" );
		mapper.matchName( "UserGroupNames", "UserGroup" );
	}
	
	    private SecurityMapConfig
	self()
	{
	    return (SecurityMapConfig)getSelf();
	}
	
	    public void
	createPrincipal( final String principal )
	{
	    final String[]  existing    = self().getPrincipalNames();
	    
	    final Set<String>   newSet	= GSetUtil.newSet( existing );
	    newSet.add( principal );
	    
	    final String[]  newOnes = GSetUtil.toStringArray( newSet );
	    
	    delegateSetAttributeNoThrow( "PrincipalNames", newOnes );
	}
	
	    public void
	removePrincipal( final String principal )
	{
	    final String[]  existing    = self().getPrincipalNames();
	    
	    final Set<String>   newSet	= GSetUtil.newSet( existing );
	    newSet.remove( principal );
	    
	    final String[]  newOnes = GSetUtil.toStringArray( newSet );
	    
	    delegateSetAttributeNoThrow( "PrincipalNames", newOnes );
	}
	
	    public void
	createUserGroup( final String userGroup )
	{
	    final String[]  existing    = self().getUserGroupNames();
	    
	    final Set<String>   newSet	= GSetUtil.newSet( existing );
	    newSet.add( userGroup );
	    
	    final String[]  newOnes = GSetUtil.toStringArray( newSet );
	    
	    delegateSetAttributeNoThrow( "UserGroupNames", newOnes );
	}
	
	    public void
	removeUserGroup( final String userGroup )
	{
	    final String[]  existing    = self().getUserGroupNames();
	    
	    final Set<String>   newSet	= GSetUtil.newSet( existing );
	    newSet.remove( userGroup );
	    
	    final String[]  newOnes = GSetUtil.toStringArray( newSet );
	    
	    delegateSetAttributeNoThrow( "UserGroupNames", newOnes );
	}
	
	/*
	    public ObjectName
	getBackendPrincipalConfigObjectName()
	{
	    return getContaineeObjectName( XTypes.BACKEND_PRINCIPAL_CONFIG );
	} 
	*/
}



