/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/src/java/com/sun/enterprise/management/config/WebContainerAvailabilityConfigFactory.java,v 1.5 2006/03/09 20:30:42 llc Exp $
 * $Revision: 1.5 $
 * $Date: 2006/03/09 20:30:42 $
 */


package com.sun.enterprise.management.config;

import java.util.Map;
import java.util.Set;
import java.util.Collections;

import javax.management.ObjectName;
import javax.management.AttributeList;

import com.sun.appserv.management.base.XTypes;
import com.sun.enterprise.management.support.oldconfig.OldAvailabilityServiceMBean;

import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.config.WebContainerAvailabilityConfigKeys;


/**
 */
public final class WebContainerAvailabilityConfigFactory extends ConfigFactory
{
	private final OldAvailabilityServiceMBean	mOldAvailabilityService;
	
		public 
	WebContainerAvailabilityConfigFactory(
		final ConfigFactoryCallback		callbacks) 
	{
		super( callbacks );
		
		mOldAvailabilityService	=
		    getOldConfigProxies().getOldAvailabilityServiceMBean( getConfigName() );
	}

	private final Set<String>	LEGAL_OPTIONAL_KEYS	= 
		GSetUtil.newUnmodifiableStringSet(
		WebContainerAvailabilityConfigKeys.WEB_CONTAINER_AVAILABILITY_ENABLED_KEY,
		WebContainerAvailabilityConfigKeys.PERSISTENCE_TYPE_KEY,
		WebContainerAvailabilityConfigKeys.PERSISTENCE_FREQUENCY_KEY,
		WebContainerAvailabilityConfigKeys.PERSISTENCE_SCOPE_KEY,
		WebContainerAvailabilityConfigKeys.PERSISTENCE_STORE_HEALTH_CHECK_ENABLED_KEY ,
		WebContainerAvailabilityConfigKeys.SSO_FAILOVER_ENABLED_KEY,
		WebContainerAvailabilityConfigKeys.HTTP_SESSION_STORE_POOL_NAME_KEY
	);
	
	    protected Set<String>
	getLegalOptionalCreateKeys()
	{
		return( LEGAL_OPTIONAL_KEYS );
	}
	
	
	
	/**
	 */
		public ObjectName 
	create( final Map<String,String> optional )
	{
		final Map<String,String>	params	= initParams( optional );

		final ObjectName	amxName	= createChild( optional );
		
		return( amxName );
	}
	
		protected void 
	internalRemove( final ObjectName objectName )
	{
		mOldAvailabilityService.removeWebContainerAvailability();
	}
	

		protected ObjectName
	createOldChildConfig( final AttributeList attrs )
	{
		final ObjectName oldObjectName = mOldAvailabilityService.createWebContainerAvailability( attrs );

		return oldObjectName;
	}
}

