/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/src/java/com/sun/enterprise/management/j2ee/J2EEApplicationImpl.java,v 1.4 2006/03/09 20:30:44 llc Exp $
 * $Revision: 1.4 $
 * $Date: 2006/03/09 20:30:44 $
 */
 
package com.sun.enterprise.management.j2ee;
 
import java.util.Set;
import java.util.Collections;

import javax.management.AttributeNotFoundException;

import com.sun.appserv.management.j2ee.J2EEApplication;
import com.sun.appserv.management.j2ee.J2EETypes;

import com.sun.appserv.management.base.XTypes;

import com.sun.appserv.management.util.misc.GSetUtil;

import com.sun.enterprise.management.support.Delegate;

/**
 */
public final class J2EEApplicationImpl
	extends J2EEDeployedObjectImplBase
{
		public
	J2EEApplicationImpl( final Delegate delegate )
	{
		super( delegate );
	}
	
	
	private static final Set<String> MODULE_TYPES	= GSetUtil.newUnmodifiableStringSet(
		J2EETypes.WEB_MODULE,
		J2EETypes.EJB_MODULE,
		J2EETypes.APP_CLIENT_MODULE,
		J2EETypes.RESOURCE_ADAPTER_MODULE );
	
		public String[]
	getmodules()
	{
		return( GSetUtil.toStringArray( getModuleObjectNameSet() ) );
	}
	
		public Set
	getModuleObjectNameSet()
	{
		return( getContaineeObjectNameSet( MODULE_TYPES ) );
	}

	/** jsr77 StateManageable impl. */

		public boolean
	isstateManageable()
	{
		return true;
	}
	
	
		protected String
	getMonitoringPeerJ2EEType()
	{
		return( XTypes.APPLICATION_MONITOR );
	}
}
