/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/src/java/com/sun/enterprise/management/j2ee/J2EEDeployedObjectImplBase.java,v 1.5 2006/03/09 20:30:44 llc Exp $
 * $Revision: 1.5 $
 * $Date: 2006/03/09 20:30:44 $
 */
 
package com.sun.enterprise.management.j2ee;

import java.util.Set;
import java.util.Collections;


import javax.management.ObjectName;
import javax.management.AttributeNotFoundException;


import com.sun.appserv.management.j2ee.J2EEDeployedObject;
import com.sun.appserv.management.j2ee.StateManageable;

import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.enterprise.management.support.Delegate;

/**
 */
public class J2EEDeployedObjectImplBase extends J2EEManagedObjectImplBase
	// implements J2EEDeployedObject
{
		public
	J2EEDeployedObjectImplBase(
		final Delegate delegate )
	{
		super( delegate );
	}
	
		public String
	getdeploymentDescriptor()
	{
		return( (String)delegateGetAttributeNoThrow( "deploymentDescriptor" ) );
	}
	
		public String
	getserver()
	{
		return( getServerObjectName().toString() );
	}
	
	private final static Set<String>	DONT_MAP_SET =
	    GSetUtil.newUnmodifiableStringSet("deploymentDescriptor", "server" );
	
		protected Set<String>
	getDontMapAttributeNames()
	{
		return( Collections.unmodifiableSet(
		    GSetUtil.newSet( DONT_MAP_SET, super.getDontMapAttributeNames() ) ));
	}
	
	/** jsr77 StateManageable impl. */

		public boolean
	isstateManageable()
	{
		return( false );
	}

		public void	
	start()
	{
		checkstateManageable();
		getDelegate().invoke( "start", null, null );
		setstartTime( System.currentTimeMillis() );
	}

		public void	
	startRecursive()
	{
 		start();
	}

		public void	
	stop()
	{
		checkstateManageable();
		getDelegate().invoke( "stop", null, null );
		setstartTime( 0 );
	}

		private void
	checkstateManageable()
	{
		if ( !isstateManageable() )
		{
			throw new UnsupportedOperationException( "stateManageable is false" );
		}
	}
}




