/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.j2ee;
 
import java.util.Map;
import java.util.Set;

import javax.management.ObjectName;
import javax.management.j2ee.statistics.ServletStats;


import com.sun.appserv.management.j2ee.Servlet;
import com.sun.appserv.management.j2ee.WebModule;
import com.sun.appserv.management.j2ee.J2EETypes;

import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.base.Util;


import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.appserv.management.util.misc.ExceptionUtil;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.misc.StringUtil;
import com.sun.appserv.management.util.misc.CollectionUtil;

import com.sun.enterprise.management.support.Delegate;

import com.sun.appserv.management.monitor.statistics.AltServletStats;

import com.sun.appserv.management.monitor.WebModuleVirtualServerMonitor;
import com.sun.appserv.management.monitor.ServletMonitor;

import com.sun.enterprise.management.support.WebModuleSupport;

/**
 */
public final class ServletImpl
	extends J2EEManagedObjectImplBase
	//  implements Servlet
{
		public
	ServletImpl( final Delegate delegate )
	{
		super( delegate );
	}
	
	
	static private final Set<String>   IGNORE_MISSING =
	    GSetUtil.newUnmodifiableStringSet(
	        "maxTimeMillis", "minTimeMillis", "processingTimeMillis",
	        "requestCount", "errorCount"
	    );
	    
	/**
	    We don't map any of the Attributes derived from statistics.
	 */
	    protected void
	handleMissingOriginals( final Set<String> missingOriginals )
	{
	    missingOriginals.removeAll( IGNORE_MISSING );
	    
        super.handleMissingOriginals( missingOriginals );
	}
	
	
	
		protected String
	getMonitoringPeerJ2EEType()
	{
		return( XTypes.SERVLET_MONITOR );
	}
	
		protected ObjectName
	queryMonitoringPeerFailed( final Map<String,String> propsMap )
	{
		final WebModule			webModule	= (WebModule)getContainer();
		
		debug( "queryMonitoringPeerFailed: expecting to find " +
		    MapUtil.toString( propsMap ) );
		    
		if ( webModule == null )
		{
		    logWarning(
		        "ServletImpl.queryMonitoringPeerFailed: " +
		        "Can't get containing WebModule, my ObjectName = " + getObjectName());
		}
		
		ObjectName	result	= null;
		
		try
		{
			final WebModuleVirtualServerMonitor	webModuleVirtualServerMonitor	=
				(WebModuleVirtualServerMonitor)webModule.getMonitoringPeer();
			if ( webModuleVirtualServerMonitor == null )
			{
			    final ObjectName    objectName  = Util.getObjectName( webModule );
			    
			    final String msg = "ServletImpl.queryMonitoringPeerFailed: " +
			        "Can't get WebModuleVirtualServerMonitor for " +
			            quote( toString( objectName ));
			    debug( msg );
			    logFine( msg );
			}
			else
			{
    			final Map<String,ServletMonitor> servletMap	= 
    			    webModuleVirtualServerMonitor.getServletMonitorMap();
    			
    			final ServletMonitor	sm	= servletMap.get( getName() );
    			if ( sm != null )
    			{
    				result	= Util.getObjectName( sm );
    			}
    			else
    			{
    			    final String  servletMonitorNames = CollectionUtil.toString(
    			        Util.toObjectNames( servletMap ).values(), StringUtil.NEWLINE() );
    			    
    		        logWarning(
    		            "ServletImpl.queryMonitoringPeerFailed: " +
    		            "Can't find ServletMonitor, my ObjectName = " +
    		                quote( toString( getObjectName() ) ) +
    		                ", WebModuleVirtualServerMonitor " +
    		                quote( toString( Util.getObjectName(webModuleVirtualServerMonitor) )) +
    		                " ServletMonitor names:" + StringUtil.NEWLINE() + servletMonitorNames );
    			}
			}
		}
		catch( Exception e )
		{
		    logWarning( "ServletImpl.queryMonitoringPeerFailed: " + e);
		    debug( "ServletImpl.queryMonitoringPeerFailed: " + e + "\n" +
		        ExceptionUtil.getStackTrace( e ) );
		}
		
		return result;
	}
}





