/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.offline;

import com.sun.enterprise.admin.config.MBeanConfigException;

import com.sun.appserv.management.util.misc.StringUtil;

/**
    Support for working with our default file realm.
 */
final class AuthRealmSupport
{
    private final AuthRealmMBeanX            mAuthRealmMBean;
    private final AuthRealmConfigBeanHelper  mHelper;
    
    public final String    PREFIX  = "${com.sun.aas.instanceRoot}";
        
        public
    AuthRealmSupport( final AuthRealmConfigBeanHelper  helper )
    {
        mHelper = helper;
        
        String  file    = helper.getFile();
        
        if ( file.startsWith( PREFIX ) )
        {
            throw new IllegalArgumentException(
                "AuthRealm does not yet support ${...} values for the filename" );
        }
        
        mAuthRealmMBean = new AuthRealmMBeanX( file );
    }
	    protected void
	sdebug( Object o )
	{
	    System.out.println( "" + o );
	}
	
	    private String
	getRealmName()
	{
	    try
	    {
	        return (String)mHelper.getAttribute( "Name" );
	    }
	    catch( Exception e )
	    {
	        return null;
	    }
	}
	
        public String[]
    getGroupNames()
    {
        try
        {
            return mAuthRealmMBean.getGroupNames();
        }
        catch( MBeanConfigException e )
        {
            throw new RuntimeException( "" + e );
        }
    }
    
        public String[]
    getUserNames()
    {
        //sdebug( "AuthRealmSupport.getUserNames(): " + getRealmName() );
        
        try
        {
            final String[]  userNames   = mAuthRealmMBean.getUserNames();
            
            //sdebug( "AuthRealmSupport.getUserNames(): " + 
                //getRealmName() + ": " + StringUtil.toString( userNames ) );
            return userNames;
        }
        catch( MBeanConfigException e )
        {
            //sdebug( e.getMessage() );
            //e.printStackTrace();
            throw new RuntimeException( "" + e );
        }
    }
    
        public String[]
    getUserGroupNames( final String user )
    {
        try
        {
            return mAuthRealmMBean.getUserGroupNames( user );
        }
        catch( MBeanConfigException e )
        {
            throw new RuntimeException( "" + e );
        }
    }
    
        public void
    addUser(
        final String    user,
        final String    password,
        final String[]  groupList)
    {
        try
        {
            mAuthRealmMBean.addUser( user, password, groupList );
        }
        catch( MBeanConfigException e )
        {
            throw new RuntimeException( "" + e );
        }
    }
    
        public void
    updateUser(
        final String    user,
        final String    password,
        final String[]  groupList)
    {
        try
        {
            mAuthRealmMBean.updateUser( user, password, groupList );
        }
        catch( MBeanConfigException e )
        {
            throw new RuntimeException( "" + e );
        }
    }
    
        public void
    removeUser( final String    user)
    {
        try
        {
            mAuthRealmMBean.removeUser( user );
        }
        catch( MBeanConfigException e )
        {
            throw new RuntimeException( "" + e );
        }
    }
}

















